/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonChillerEnum class provides enumeration for the running
 * mode of a SNVT_chiller
 *
 * @author    Sean Morton
 * @creation  18 Jul 01
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:23 PM$
 * @since     Niagara 3.0
 */
public final class BLonChillerEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonChillerEnum
  {
    range
    {
      chlrOff = 0,
      chlrStart = 1,
      chlrRun = 2,
      chlrPreshutdn = 3,
      chlrService = 4,
      chlrNull = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonChillerEnum(1650293016)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for chlrOff. */
  public static final int CHLR_OFF = 0;
  /** Ordinal value for chlrStart. */
  public static final int CHLR_START = 1;
  /** Ordinal value for chlrRun. */
  public static final int CHLR_RUN = 2;
  /** Ordinal value for chlrPreshutdn. */
  public static final int CHLR_PRESHUTDN = 3;
  /** Ordinal value for chlrService. */
  public static final int CHLR_SERVICE = 4;
  /** Ordinal value for chlrNull. */
  public static final int CHLR_NULL = -1;
  
  /** BLonChillerEnum constant for chlrOff. */
  public static final BLonChillerEnum chlrOff = new BLonChillerEnum(CHLR_OFF);
  /** BLonChillerEnum constant for chlrStart. */
  public static final BLonChillerEnum chlrStart = new BLonChillerEnum(CHLR_START);
  /** BLonChillerEnum constant for chlrRun. */
  public static final BLonChillerEnum chlrRun = new BLonChillerEnum(CHLR_RUN);
  /** BLonChillerEnum constant for chlrPreshutdn. */
  public static final BLonChillerEnum chlrPreshutdn = new BLonChillerEnum(CHLR_PRESHUTDN);
  /** BLonChillerEnum constant for chlrService. */
  public static final BLonChillerEnum chlrService = new BLonChillerEnum(CHLR_SERVICE);
  /** BLonChillerEnum constant for chlrNull. */
  public static final BLonChillerEnum chlrNull = new BLonChillerEnum(CHLR_NULL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonChillerEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonChillerEnum make(int ordinal)
  {
    return (BLonChillerEnum)chlrOff.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonChillerEnum make(String tag)
  {
    return (BLonChillerEnum)chlrOff.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonChillerEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
