/*
 * Copyright 2010 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.sys.*;

/**
 * BUnionQualifier contains info for one branch in a union.
 * <p>
 * @author    Robert Adams
 * @creation  20 Jan 2010
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:36 AM$
 * @since     Niagara 3.0
 */
public final class BUnionQualifier
  extends BStruct
{
  /*-

  class BUnionQualifier
  {
    properties
    {
      branch : String
        flags { readonly }
        default {[ "" ]}
      branchProps : String
        flags { readonly }
        default {[ "" ]}
      conditions : String
       flags { readonly }
       default {[ "" ]}
   }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BUnionQualifier(3719339578)1.0$ @*/
/* Generated Fri Jan 30 14:06:20 EST 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "branch"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code branch} property.
   * @see #getBranch
   * @see #setBranch
   */
  public static final Property branch = newProperty(Flags.READONLY, "",null);
  
  /**
   * Get the {@code branch} property.
   * @see #branch
   */
  public String getBranch() { return getString(branch); }
  
  /**
   * Set the {@code branch} property.
   * @see #branch
   */
  public void setBranch(String v) { setString(branch,v,null); }

////////////////////////////////////////////////////////////////
// Property "branchProps"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code branchProps} property.
   * @see #getBranchProps
   * @see #setBranchProps
   */
  public static final Property branchProps = newProperty(Flags.READONLY, "",null);
  
  /**
   * Get the {@code branchProps} property.
   * @see #branchProps
   */
  public String getBranchProps() { return getString(branchProps); }
  
  /**
   * Set the {@code branchProps} property.
   * @see #branchProps
   */
  public void setBranchProps(String v) { setString(branchProps,v,null); }

////////////////////////////////////////////////////////////////
// Property "conditions"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code conditions} property.
   * @see #getConditions
   * @see #setConditions
   */
  public static final Property conditions = newProperty(Flags.READONLY, "",null);
  
  /**
   * Get the {@code conditions} property.
   * @see #conditions
   */
  public String getConditions() { return getString(conditions); }
  
  /**
   * Set the {@code conditions} property.
   * @see #conditions
   */
  public void setConditions(String v) { setString(conditions,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUnionQualifier.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public String toString(Context c) { return getConditions(); }

}
