/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 *  This class file represents the network variable data 
 *  described in Appendix A.4.1: Neuron Chip Data Structures 
 *  in the Neuron Chip Data Book.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  8 Jan 01
 * @version   $Revision: 2$ $Date: 9/18/01 9:50:15 AM$
 * @since     Niagara 3.0
 */
public class BNvConfigData
  extends BStruct
{  
  public static final int DEFAULT_ADDR_INDEX  = -1;
  /*-
  
  class BNvConfigData
  {
    properties
    {
      priority:     boolean             
        -- Flag to indicate if nv uses priority messaging.  
        flags { defaultOnClone, readonly }
        default {[ false ]}
      direction:     BLonNvDirection  
        -- Flag to indicate if nv is input or output.
        flags { readonly }
        default {[ BLonNvDirection.input ]}
      selector:      int                 
        -- Selector used to bind nvs.  
        flags { defaultOnClone, readonly }
        default {[ -1 ]}
        slotfacets {[ BFacets.make(BFacets.RADIX,BInteger.make(16)) ]}
      turnAround:    boolean             
        -- Flag to indicate if this is a turnaround nv.  
        flags { defaultOnClone, readonly }
        default {[ false ]}
      serviceType:   BLonServiceType  
         -- Service type used for updates if nv is bound.
        flags { readonly }
        default {[ BLonServiceType.unacked ]}
      authenticated:  boolean
        -- Flag to indicate if this nv will use authenticated
        -- updates if it is bound.  
        flags { defaultOnClone, readonly }
        default {[ false ]}
      addrIndex:     int   
        -- Index in address table for implicit addressing of
        -- nv updates. Valid values of 0-14 if configured
        -- or -1 if not configured. In devices supporting extended 
        -- address table valid values are 0 - 65534
        flags { defaultOnClone, readonly }
        default {[ DEFAULT_ADDR_INDEX ]}
     }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BNvConfigData(3805525297)1.0$ @*/
/* Generated Tue Feb 20 14:19:38 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "priority"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>priority</code> property.
   * Flag to indicate if nv uses priority messaging.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getPriority
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setPriority
   */
  public static final Property priority = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, false,null);
  
  /**
   * Get the <code>priority</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#priority
   */
  public boolean getPriority() { return getBoolean(priority); }
  
  /**
   * Set the <code>priority</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#priority
   */
  public void setPriority(boolean v) { setBoolean(priority,v,null); }

////////////////////////////////////////////////////////////////
// Property "direction"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>direction</code> property.
   * Flag to indicate if nv is input or output.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getDirection
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setDirection
   */
  public static final Property direction = newProperty(Flags.READONLY, BLonNvDirection.input,null);
  
  /**
   * Get the <code>direction</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#direction
   */
  public BLonNvDirection getDirection() { return (BLonNvDirection)get(direction); }
  
  /**
   * Set the <code>direction</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#direction
   */
  public void setDirection(BLonNvDirection v) { set(direction,v,null); }

////////////////////////////////////////////////////////////////
// Property "selector"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selector</code> property.
   * Selector used to bind nvs.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getSelector
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setSelector
   */
  public static final Property selector = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, -1,BFacets.make(BFacets.RADIX,BInteger.make(16)) );
  
  /**
   * Get the <code>selector</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#selector
   */
  public int getSelector() { return getInt(selector); }
  
  /**
   * Set the <code>selector</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#selector
   */
  public void setSelector(int v) { setInt(selector,v,null); }

////////////////////////////////////////////////////////////////
// Property "turnAround"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>turnAround</code> property.
   * Flag to indicate if this is a turnaround nv.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getTurnAround
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setTurnAround
   */
  public static final Property turnAround = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, false,null);
  
  /**
   * Get the <code>turnAround</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#turnAround
   */
  public boolean getTurnAround() { return getBoolean(turnAround); }
  
  /**
   * Set the <code>turnAround</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#turnAround
   */
  public void setTurnAround(boolean v) { setBoolean(turnAround,v,null); }

////////////////////////////////////////////////////////////////
// Property "serviceType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>serviceType</code> property.
   * Service type used for updates if nv is bound.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getServiceType
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setServiceType
   */
  public static final Property serviceType = newProperty(Flags.READONLY, BLonServiceType.unacked,null);
  
  /**
   * Get the <code>serviceType</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#serviceType
   */
  public BLonServiceType getServiceType() { return (BLonServiceType)get(serviceType); }
  
  /**
   * Set the <code>serviceType</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#serviceType
   */
  public void setServiceType(BLonServiceType v) { set(serviceType,v,null); }

////////////////////////////////////////////////////////////////
// Property "authenticated"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>authenticated</code> property.
   * Flag to indicate if this nv will use authenticated
   * updates if it is bound.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getAuthenticated
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setAuthenticated
   */
  public static final Property authenticated = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, false,null);
  
  /**
   * Get the <code>authenticated</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#authenticated
   */
  public boolean getAuthenticated() { return getBoolean(authenticated); }
  
  /**
   * Set the <code>authenticated</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#authenticated
   */
  public void setAuthenticated(boolean v) { setBoolean(authenticated,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrIndex</code> property.
   * Index in address table for implicit addressing of nv updates. Valid values of 0-14 if configured or -1 if not configured. In devices supporting extended address table valid values are 0 - 65534
   * @see javax.baja.lonworks.datatypes.BNvConfigData#getAddrIndex
   * @see javax.baja.lonworks.datatypes.BNvConfigData#setAddrIndex
   */
  public static final Property addrIndex = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, DEFAULT_ADDR_INDEX,null);
  
  /**
   * Get the <code>addrIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#addrIndex
   */
  public int getAddrIndex() { return getInt(addrIndex); }
  
  /**
   * Set the <code>addrIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BNvConfigData#addrIndex
   */
  public void setAddrIndex(int v) { setInt(addrIndex,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNvConfigData.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public boolean isAlias() { return false; }

  /**
   *  Write a network byte image of this NvConfig to a
   *  LonOutputStream.
   *  
   *  @param  outputStream  data stream of message
   */
  public void writeNetworkBytes(LonOutputStream out)
  {
    int mrk = out.setBitFieldMark();
    
    out.writeBooleanBit(getPriority(),0,7,1);
    out.writeBooleanBit(isOutput(),0,6,1);
    
    int sel = getSelector();
    out.writeBit(sel>>8,0,0,6);
    out.writeUnsigned8(sel);

    out.writeBooleanBit(getTurnAround(),2,7,1);
    out.writeBit(getServiceType().getOrdinal(),2,5,2);
    out.writeBooleanBit(getAuthenticated(),2,4,1);
    
    int ndx = (getAddrIndex()==DEFAULT_ADDR_INDEX) ? UNUSED_ADDR_INDEX : getAddrIndex();
    out.writeBit(ndx,2,0,4);
    
    out.resetBitFieldMark(mrk);
  }

  /**
   *  Extract the Nv Config Response data from
   *  the LonInputStream 
   *  
   *  @param  inputStream  data stream of message
   */
  public void fromInputStream(LonInputStream in)
  {
    int mrk = in.setBitFieldMark();

    setPriority       (in.readBooleanBit(0,7,1));
    
    BLonNvDirection dir = (in.readBooleanBit(0,6,1)) ? BLonNvDirection.output : BLonNvDirection.input;
    setDirection      (dir);
    
    int sel = (in.readBit(0,0,6)<<8) | in.readUnsigned8();
    setSelector       (sel);
    setTurnAround     (in.readBooleanBit(2,7,1));
    setServiceType    (BLonServiceType.make(in.readBit(2,5,2)));
    setAuthenticated  (in.readBooleanBit(2,4,1));
    
    int ndx = in.readBit(2,0,4);
    setAddrIndex      (ndx==UNUSED_ADDR_INDEX ? DEFAULT_ADDR_INDEX : ndx);    
  
    in.resetBitFieldMark(mrk);
    
  }


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////  
                                                                         
//  private static final int PRIORITY_NET_IMAGE        = 0x80;
//  private static final int DIRECTION_NET_IMAGE       = 0x40;
//  private static final int TURNAROUND_NET_IMAGE      = 0x80;
//  private static final int SERVICE_TYPE_NET_IMAGE    = 0x60;
//  private static final int AUTH_NET_IMAGE            = 0x10;
//  private static final int ADDR_INDEX_NET_IMAGE      = 0x0F;
//
//  private static final int UPPER_SEL_MASK            = 0x3F;
//  private static final int LOWER_SEL_MASK            = 0xFF;
 
  /** Value of base unbound selector.  Unbound selector
   *  for specific nv is UNBOUND_NV_BASE_SELECTOR - nvIndex */
  public static final int UNBOUND_NV_BASE_SELECTOR = 0x3fff;

  public static final int MAX_BOUND_SELECTOR  = 0x02FFF;
 
  /** Default value for address index. */
  public static final int UNUSED_ADDR_INDEX     = 15;
  public static final int UNUSED_EXT_ADDR_INDEX = 65535;

////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////  
  public boolean isInput()   { return getDirection() == BLonNvDirection.input; }
  public boolean isOutput()  { return getDirection() == BLonNvDirection.output; }
  public boolean isBoundNv() { return (getSelector() >= 0) && (getSelector() < MAX_BOUND_SELECTOR); }
  
  /**
   * Set nv to unbound state 
   */
  public void setUnbound(int nvIndex)
  {
    setSelector(UNBOUND_NV_BASE_SELECTOR - nvIndex);
    setTurnAround(false);
    setAddrIndex(DEFAULT_ADDR_INDEX); 
  }

  public String toString(Context c)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("sel:0x").append(Integer.toString(getSelector(),16));  
    sb.append(",").append(getServiceType());  
    sb.append(",adr:").append(getAddrIndex());  
    if(getDirection()==BLonNvDirection.input) sb.append(",in"); else sb.append(",out");  
    if(getTurnAround()) sb.append(",turn");  
    if(getPriority())sb.append(",pri");  
    if(getAuthenticated()) sb.append(",auth");  
    return sb.toString();
  }

  /**
   * Get serviceType suitable for nv writes. This will filter serviceType
   * to change BLonServiceType.request to BLonServiceType.acked.
   * @return one of BLonServiceType.acked,unacked,unackedRpt
   */
  public BLonServiceType getWriteServiceType()
  {
    return getServiceType().getWriteServiceType();
  }
  
}
