/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.loncomm.NLonLinkLayer;

import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.enums.BLonReceiveTimer;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.sys.*;

/**
 *   BLonCommConfig specifies the properties need to configure the
 * communication stack for a single lonworks connection.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  19 Feb 02
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BLonCommConfig
  extends BStruct
{  
  /**
  
   */
        

  /*-
  
  class BLonCommConfig
  {
    properties
    {
      deviceName: String  
        -- The name of lonworks system device to be accessed by the parent BLonNetwork.
        default {[ "LON1" ]}
        
      linkDebug: boolean
        -- The debug flag to enable/disable debug mode 
        -- simple boolean.
        default {[ false ]}
        
      repeatTimer: BLonRepeatTimer
        -- Specifies the time interval between repetitions of
        -- an outgoing message using repeat service.
        default {[ BLonRepeatTimer.milliSec96 ]}

      receiveTimer: BLonReceiveTimer
        -- Specifies the time interval in which messages with
        -- the same tag will be considered duplicates.
        default {[ BLonReceiveTimer.milliSec384 ]}

      transmitTimer: BLonRepeatTimer
        -- Specifies the time interval between retries of
        -- an outgoing message using req/resp or acknowledged service.
        default {[ BLonRepeatTimer.milliSec96 ]}

      retryCount: int
        -- Specifies the number of retries for repeat, 
        -- req/resp or acknowledged service.
        default {[ 3 ]}

    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BLonCommConfig(812071385)1.0$ @*/
/* Generated Tue May 04 09:28:19 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceName</code> property.
   * The name of lonworks system device to be accessed by the parent BLonNetwork.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#getDeviceName
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#setDeviceName
   */
  public static final Property deviceName = newProperty(0, "LON1",null);
  
  /**
   * Get the <code>deviceName</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#deviceName
   */
  public String getDeviceName() { return getString(deviceName); }
  
  /**
   * Set the <code>deviceName</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#deviceName
   */
  public void setDeviceName(String v) { setString(deviceName,v,null); }

////////////////////////////////////////////////////////////////
// Property "linkDebug"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>linkDebug</code> property.
   * The debug flag to enable/disable debug mode simple
   * boolean.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#getLinkDebug
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#setLinkDebug
   */
  public static final Property linkDebug = newProperty(0, false,null);
  
  /**
   * Get the <code>linkDebug</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#linkDebug
   */
  public boolean getLinkDebug() { return getBoolean(linkDebug); }
  
  /**
   * Set the <code>linkDebug</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#linkDebug
   */
  public void setLinkDebug(boolean v) { setBoolean(linkDebug,v,null); }

////////////////////////////////////////////////////////////////
// Property "repeatTimer"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>repeatTimer</code> property.
   * Specifies the time interval between repetitions of
   * an outgoing message using repeat service.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#getRepeatTimer
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#setRepeatTimer
   */
  public static final Property repeatTimer = newProperty(0, BLonRepeatTimer.milliSec96,null);
  
  /**
   * Get the <code>repeatTimer</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#repeatTimer
   */
  public BLonRepeatTimer getRepeatTimer() { return (BLonRepeatTimer)get(repeatTimer); }
  
  /**
   * Set the <code>repeatTimer</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#repeatTimer
   */
  public void setRepeatTimer(BLonRepeatTimer v) { set(repeatTimer,v,null); }

////////////////////////////////////////////////////////////////
// Property "receiveTimer"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>receiveTimer</code> property.
   * Specifies the time interval in which messages with
   * the same tag will be considered duplicates.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#getReceiveTimer
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#setReceiveTimer
   */
  public static final Property receiveTimer = newProperty(0, BLonReceiveTimer.milliSec384,null);
  
  /**
   * Get the <code>receiveTimer</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#receiveTimer
   */
  public BLonReceiveTimer getReceiveTimer() { return (BLonReceiveTimer)get(receiveTimer); }
  
  /**
   * Set the <code>receiveTimer</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#receiveTimer
   */
  public void setReceiveTimer(BLonReceiveTimer v) { set(receiveTimer,v,null); }

////////////////////////////////////////////////////////////////
// Property "transmitTimer"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transmitTimer</code> property.
   * Specifies the time interval between retries of an outgoing message using req/resp or acknowledged service.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#getTransmitTimer
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#setTransmitTimer
   */
  public static final Property transmitTimer = newProperty(0, BLonRepeatTimer.milliSec96,null);
  
  /**
   * Get the <code>transmitTimer</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#transmitTimer
   */
  public BLonRepeatTimer getTransmitTimer() { return (BLonRepeatTimer)get(transmitTimer); }
  
  /**
   * Set the <code>transmitTimer</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#transmitTimer
   */
  public void setTransmitTimer(BLonRepeatTimer v) { set(transmitTimer,v,null); }

////////////////////////////////////////////////////////////////
// Property "retryCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>retryCount</code> property.
   * Specifies the number of retries for repeat, req/resp
   * or acknowledged service.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#getRetryCount
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#setRetryCount
   */
  public static final Property retryCount = newProperty(0, 3,null);
  
  /**
   * Get the <code>retryCount</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#retryCount
   */
  public int getRetryCount() { return getInt(retryCount); }
  
  /**
   * Set the <code>retryCount</code> property.
   * @see javax.baja.lonworks.datatypes.BLonCommConfig#retryCount
   */
  public void setRetryCount(int v) { setInt(retryCount,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonCommConfig.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("commConfig.png");

  /** */
  public LonLinkLayer makeLonLinkLayer(LonComm lc, BLonNetwork lon) 
    { return new NLonLinkLayer(lc, lon);  }

}
