/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.naming.BOrd;
import javax.baja.sys.*;

/**
 * BImportParameters list options to constrain the 
 * importXml action in BDynamicDevice
 *
 * @author    Robert Adams
 * @creation  18 Oct 01
 * @version   $Revision: 1$ $Date: 10/18/01 2:56:30 PM$
 * @since     Niagara 3.0
 */
public class BImportParameters
  extends BStruct
{ 

  /*-
  
  class BImportParameters
  {
    properties
    {
      xmlFile: BOrd
        -- The name of xml file used int importXml action.
        default {[ BOrd.NULL ]}
        slotfacets {[ BFacets.make("allowLocalAccess", BBoolean.TRUE) ]}
      xifFile: BOrd
        -- The name of xif file used to describe the device.
        flags {hidden }
        default {[ BOrd.NULL ]}
        slotfacets {[ BFacets.make("allowLocalAccess", BBoolean.TRUE) ]}
      resFile: BOrd
        -- The name of resource type file used to describe the device.
        flags {hidden }
        default {[ BOrd.NULL ]}
        slotfacets {[ BFacets.make("allowLocalAccess", BBoolean.TRUE) ]}
      syncNvConfig: boolean
        -- Should operation include upload of nvConfig data from device.
        flags {hidden }
        default {[ false ]}
      useLonObjects: boolean
        -- Should lonComponents be partioned in specified objects.
        default {[ false ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BImportParameters(2837756397)1.0$ @*/
/* Generated Thu Apr 26 14:13:51 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "xmlFile"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>xmlFile</code> property.
   * The name of xml file used int importXml action.
   * @see javax.baja.lonworks.datatypes.BImportParameters#getXmlFile
   * @see javax.baja.lonworks.datatypes.BImportParameters#setXmlFile
   */
  public static final Property xmlFile = newProperty(0, BOrd.NULL,BFacets.make("allowLocalAccess", BBoolean.TRUE) );
  
  /**
   * Get the <code>xmlFile</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#xmlFile
   */
  public BOrd getXmlFile() { return (BOrd)get(xmlFile); }
  
  /**
   * Set the <code>xmlFile</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#xmlFile
   */
  public void setXmlFile(BOrd v) { set(xmlFile,v,null); }

////////////////////////////////////////////////////////////////
// Property "xifFile"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>xifFile</code> property.
   * The name of xif file used to describe the device.
   * @see javax.baja.lonworks.datatypes.BImportParameters#getXifFile
   * @see javax.baja.lonworks.datatypes.BImportParameters#setXifFile
   */
  public static final Property xifFile = newProperty(Flags.HIDDEN, BOrd.NULL,BFacets.make("allowLocalAccess", BBoolean.TRUE) );
  
  /**
   * Get the <code>xifFile</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#xifFile
   */
  public BOrd getXifFile() { return (BOrd)get(xifFile); }
  
  /**
   * Set the <code>xifFile</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#xifFile
   */
  public void setXifFile(BOrd v) { set(xifFile,v,null); }

////////////////////////////////////////////////////////////////
// Property "resFile"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resFile</code> property.
   * The name of resource type file used to describe the
   * device.
   * @see javax.baja.lonworks.datatypes.BImportParameters#getResFile
   * @see javax.baja.lonworks.datatypes.BImportParameters#setResFile
   */
  public static final Property resFile = newProperty(Flags.HIDDEN, BOrd.NULL,BFacets.make("allowLocalAccess", BBoolean.TRUE) );
  
  /**
   * Get the <code>resFile</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#resFile
   */
  public BOrd getResFile() { return (BOrd)get(resFile); }
  
  /**
   * Set the <code>resFile</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#resFile
   */
  public void setResFile(BOrd v) { set(resFile,v,null); }

////////////////////////////////////////////////////////////////
// Property "syncNvConfig"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>syncNvConfig</code> property.
   * Should operation include upload of nvConfig data from
   * device.
   * @see javax.baja.lonworks.datatypes.BImportParameters#getSyncNvConfig
   * @see javax.baja.lonworks.datatypes.BImportParameters#setSyncNvConfig
   */
  public static final Property syncNvConfig = newProperty(Flags.HIDDEN, false,null);
  
  /**
   * Get the <code>syncNvConfig</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#syncNvConfig
   */
  public boolean getSyncNvConfig() { return getBoolean(syncNvConfig); }
  
  /**
   * Set the <code>syncNvConfig</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#syncNvConfig
   */
  public void setSyncNvConfig(boolean v) { setBoolean(syncNvConfig,v,null); }

////////////////////////////////////////////////////////////////
// Property "useLonObjects"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>useLonObjects</code> property.
   * Should lonComponents be partioned in specified objects.
   * @see javax.baja.lonworks.datatypes.BImportParameters#getUseLonObjects
   * @see javax.baja.lonworks.datatypes.BImportParameters#setUseLonObjects
   */
  public static final Property useLonObjects = newProperty(0, false,null);
  
  /**
   * Get the <code>useLonObjects</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#useLonObjects
   */
  public boolean getUseLonObjects() { return getBoolean(useLonObjects); }
  
  /**
   * Set the <code>useLonObjects</code> property.
   * @see javax.baja.lonworks.datatypes.BImportParameters#useLonObjects
   */
  public void setUseLonObjects(boolean v) { setBoolean(useLonObjects,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BImportParameters.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /** Empty constructor.*/
  public BImportParameters() {}
  
//  public BImportParameters(BOrd ord) { setXmlFile(ord); }
  
  /** Create BImportParameters with syncNvConfig set to the specified value.*/
  public BImportParameters(boolean sync)
  {
    setSyncNvConfig(sync);
  }
  
  /** Create BImportParameters with syncNvConfig and useLonObjects set to the specified value.*/
  public BImportParameters(boolean sync, boolean use)
  {
    setSyncNvConfig(sync);
    setUseLonObjects(use);
  }
}
