/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.sys.*;

/**
 *  Contains the data in lonworks device address table. A lonworks
 *  address table can have up to 15 entries. See Neuron Chip Data Book A.3.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  8 Nov 00
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BExtAddressTable
  extends BComponent
{  
 /*-
  
  class BExtAddressTable
  {
    properties
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BExtAddressTable(2413758827)1.0$ @*/
/* Generated Fri Dec 15 16:33:39 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BExtAddressTable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BExtAddressEntry getAddressEntry(int index)
  {
    String name = propName(index);
    Property p = getProperty(name);
    if(p==null) return BExtAddressEntry.DEFAULT;
    return (BExtAddressEntry)get(p);
  } 
  
  public boolean isEntryInUse(int index)
  {
    String name = propName(index);
    Property p = getProperty(name);
    return (p!=null);
  }
  
  public void setAddressEntry(int index, BIAddressEntry ie)
  {
    setAddressEntry(index, ie, null); 
  }
    
  public void setAddressEntry(int index, BIAddressEntry ie, Context c)
  {
    BExtAddressEntry e = BExtAddressEntry.make(ie);
    String name = propName(index);
    Property p = getProperty(name);
    if(p==null)
      add(name,e,c);
    else
      set(p,e,c);
  }    
  
  public void clearTable()
  {
    removeAll();
  }
  private String propName(int ndx) { return "adrEntry" + ndx; }

  
}
