/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.sys.*;

/**
 *   This class file ???.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  8 Nov 00
 * @version   $Revision: 2$ $Date: 9/18/01 9:49:26 AM$
 * @since     Niagara 3.0
 */
public class BConfigProps
  extends BStruct
{  
  /**
   * No arg constructor
   */
  public BConfigProps()
  {
  }

  /*-
  
  class BConfigProps
  {
    properties
    {
      configIndex: int
        -- Scpt/Ucpt integer identifier
        flags { readonly }
        default {[ 0 ]}

      offset: int
        -- offset in config parameter value file
        flags { readonly }
        default {[ 0 ]}

      length: int
        -- length of config parameter value
        flags { readonly }
        default {[ 0 ]}

      mfgDefined: boolean
        -- false if parameter is Scpt, true if Ucpt
        flags { readonly }
        default {[ false ]}

      modifyFlag: BModifyFlags
        -- indicates conditions for modifying this config property 
        flags { readonly }
        default {[ BModifyFlags.DEFAULT ]}

      scope: BLonConfigScope
        -- Indicates scope of config parameter 0 node, 1 object, 2 nv 
        flags { readonly }
        default {[ BLonConfigScope.node ]}
      
      select: String 
        -- list of objects/nvs controled by config parameter 
        flags { readonly }
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BConfigProps(3889528387)1.0$ @*/
/* Generated Fri Dec 17 11:12:27 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "configIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>configIndex</code> property.
   * Scpt/Ucpt integer identifier
   * @see javax.baja.lonworks.datatypes.BConfigProps#getConfigIndex
   * @see javax.baja.lonworks.datatypes.BConfigProps#setConfigIndex
   */
  public static final Property configIndex = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>configIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#configIndex
   */
  public int getConfigIndex() { return getInt(configIndex); }
  
  /**
   * Set the <code>configIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#configIndex
   */
  public void setConfigIndex(int v) { setInt(configIndex,v,null); }

////////////////////////////////////////////////////////////////
// Property "offset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offset</code> property.
   * offset in config parameter value file
   * @see javax.baja.lonworks.datatypes.BConfigProps#getOffset
   * @see javax.baja.lonworks.datatypes.BConfigProps#setOffset
   */
  public static final Property offset = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>offset</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#offset
   */
  public int getOffset() { return getInt(offset); }
  
  /**
   * Set the <code>offset</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#offset
   */
  public void setOffset(int v) { setInt(offset,v,null); }

////////////////////////////////////////////////////////////////
// Property "length"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>length</code> property.
   * length of config parameter value
   * @see javax.baja.lonworks.datatypes.BConfigProps#getLength
   * @see javax.baja.lonworks.datatypes.BConfigProps#setLength
   */
  public static final Property length = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>length</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#length
   */
  public int getLength() { return getInt(length); }
  
  /**
   * Set the <code>length</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#length
   */
  public void setLength(int v) { setInt(length,v,null); }

////////////////////////////////////////////////////////////////
// Property "mfgDefined"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>mfgDefined</code> property.
   * false if parameter is Scpt, true if Ucpt
   * @see javax.baja.lonworks.datatypes.BConfigProps#getMfgDefined
   * @see javax.baja.lonworks.datatypes.BConfigProps#setMfgDefined
   */
  public static final Property mfgDefined = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>mfgDefined</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#mfgDefined
   */
  public boolean getMfgDefined() { return getBoolean(mfgDefined); }
  
  /**
   * Set the <code>mfgDefined</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#mfgDefined
   */
  public void setMfgDefined(boolean v) { setBoolean(mfgDefined,v,null); }

////////////////////////////////////////////////////////////////
// Property "modifyFlag"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>modifyFlag</code> property.
   * indicates conditions for modifying this config property
   * @see javax.baja.lonworks.datatypes.BConfigProps#getModifyFlag
   * @see javax.baja.lonworks.datatypes.BConfigProps#setModifyFlag
   */
  public static final Property modifyFlag = newProperty(Flags.READONLY, BModifyFlags.DEFAULT,null);
  
  /**
   * Get the <code>modifyFlag</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#modifyFlag
   */
  public BModifyFlags getModifyFlag() { return (BModifyFlags)get(modifyFlag); }
  
  /**
   * Set the <code>modifyFlag</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#modifyFlag
   */
  public void setModifyFlag(BModifyFlags v) { set(modifyFlag,v,null); }

////////////////////////////////////////////////////////////////
// Property "scope"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scope</code> property.
   * Indicates scope of config parameter 0 node, 1 object,
   * 2 nv
   * @see javax.baja.lonworks.datatypes.BConfigProps#getScope
   * @see javax.baja.lonworks.datatypes.BConfigProps#setScope
   */
  public static final Property scope = newProperty(Flags.READONLY, BLonConfigScope.node,null);
  
  /**
   * Get the <code>scope</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#scope
   */
  public BLonConfigScope getScope() { return (BLonConfigScope)get(scope); }
  
  /**
   * Set the <code>scope</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#scope
   */
  public void setScope(BLonConfigScope v) { set(scope,v,null); }

////////////////////////////////////////////////////////////////
// Property "select"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>select</code> property.
   * list of objects/nvs controled by config parameter
   * @see javax.baja.lonworks.datatypes.BConfigProps#getSelect
   * @see javax.baja.lonworks.datatypes.BConfigProps#setSelect
   */
  public static final Property select = newProperty(Flags.READONLY, "",null);
  
  /**
   * Get the <code>select</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#select
   */
  public String getSelect() { return getString(select); }
  
  /**
   * Set the <code>select</code> property.
   * @see javax.baja.lonworks.datatypes.BConfigProps#select
   */
  public void setSelect(String v) { setString(select,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BConfigProps.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public String toString(Context c)
  {
    StringBuffer sb = new StringBuffer();
    sb.append(!getMfgDefined() ? "scpt:" : "ucpt:");
    sb.append(getConfigIndex());  
   
    sb.append(",").append(getScope());
    if(getScope()!=BLonConfigScope.node) sb.append(".").append(getSelect());
    
    sb.append(",").append(getModifyFlag());
   
    return sb.toString();
  }
  
}
