/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.NvDev;

import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.sys.*;
import javax.baja.util.BFolder;

/**
 * BLonDeviceFolder is the standard container to use 
 * under LonDeviceNetwork to organize Devices.
 *
 * @author    Robert Adams
 * @creation  13 Sept 04
 * @version   $Revision: 1$ $Date: 9/12/2004 1:39:32 PM$
 * @since     Baja 1.0
 */
public class BLonObjectFolder
  extends BFolder
  implements BILonLoadable
{ 

  /*-

  class BLonObjectFolder
  {
    actions
    {
      upload(parameters: BUploadParameters)
        -- Upload reads data from the physical device.
        -- flags { async }
        default {[ new BUploadParameters() ]}
      download(parameters: BDownloadParameters)
        -- Download writes data to the physical device.
        -- flags { async }
        default {[ new BDownloadParameters() ]}
    }
  }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.BLonObjectFolder(4209420744)1.0$ @*/
/* Generated Mon Feb 06 16:13:44 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "upload"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>upload</code> action.
   * Upload reads data from the physical device. flags { async }
   * @see javax.baja.lonworks.BLonObjectFolder#upload()
   */
  public static final Action upload = newAction(0,new BUploadParameters(),null);
  
  /**
   * Invoke the <code>upload</code> action.
   * @see javax.baja.lonworks.BLonObjectFolder#upload
   */
  public void upload(BUploadParameters parameters) { invoke(upload,parameters,null); }

////////////////////////////////////////////////////////////////
// Action "download"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>download</code> action.
   * Download writes data to the physical device. flags
   * { async }
   * @see javax.baja.lonworks.BLonObjectFolder#download()
   */
  public static final Action download = newAction(0,new BDownloadParameters(),null);
  
  /**
   * Invoke the <code>download</code> action.
   * @see javax.baja.lonworks.BLonObjectFolder#download
   */
  public void download(BDownloadParameters parameters) { invoke(download,parameters,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonObjectFolder.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
        
////////////////////////////////////////////////////////////////
// IDeviceFolder
////////////////////////////////////////////////////////////////

  public boolean isParentLegal(BComponent parent)
  {
    return ( parent.getType().is(BLonDevice.TYPE) ||
             parent.getType().is(BLonObjectFolder.TYPE) );
  }
  
  public boolean isChildLegal(BComponent child)
  {
    if( child.getType().is(BDeviceFolder.TYPE)/* &&
        !child.getType().is(BLonObjectFolder.TYPE)*/ )
    {
      return false;
    }    
    return true;
  }

  /** Change wire sheets */
  public AgentList getAgents(Context cx)
  {
    AgentList list = super.getAgents(cx);
    return NvDev.fixWireSheet(list,cx);
  }
  
  
  /** Don't allow second local device. 
  public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context)
  {
    if(value.getType().is(BLocalLonDevice.TYPE)) 
      throw new LocalizableRuntimeException("lonworks", "addLocalDeviceError");
  }
*/ 
  /** Let LonNetmgmt know about new devices and routers. 
  public void added(Property prop, Context context)
  {
    try
    {
      if(!isRunning()) return;

      if(prop.getType().is(BLonDevice.TYPE))
        getLonNetwork().netmgmt().deviceAdded((BLonDevice)get(prop));
      else if(prop.getType().is(BLonRouter.TYPE))
        getLonNetwork().netmgmt().routerAdded((BLonRouter)get(prop));
    }
    finally
    {
      super.added(prop,context);
    }
  }
  */  
  /**
   * Get the parent network.
   */
  public final BLonNetwork getLonNetwork()
  {            
    BComplex p = getParent();
    while(p != null)
    {
      if(p.getType().is(BLonNetwork.TYPE))
        return (BLonNetwork)p;
      p = p.getParent();
    }
    throw new IllegalStateException();
  }
  /**
   * Get the parent network.
   */
  public final BLonDevice getLonDevice()
  {            
    BComplex p = getParent();
    while(p != null)
    {
      if(p.getType().is(BLonDevice.TYPE))
        return (BLonDevice)p;
      p = p.getParent();
    }
    throw new IllegalStateException();
  }
 
////////////////////////////////////////////////////////////
//  BILonLoadable Implementation
////////////////////////////////////////////////////////////
  /** Callback for processing upLoad. */
  public final void doUpload(BUploadParameters p, Context cx)
    throws Exception
  {
    getLonDevice().checkState();
    new BUploadJob(this,p,cx).submit(cx);
  }
  
  /** Callback for processing downLoad. */
  public final void doDownload(BDownloadParameters p, Context cx)
    throws Exception
  {
    getLonDevice().checkState();
    new BDownloadJob(this,p,cx).submit(cx);
  }
  
   
  /** Override point to customize upload process.  This will be called before the upload job is initiated. 
   * If a subclass wishes to cancel the upload, then a LocalizableRuntimeException should be thrown.*/ 
  public void checkUpload(){}
  /** Override point to customize upload process.  This will be called at the beginning of an upload operation. */ //after initUpload() 
  public void beginUpload()
  {
    BLonDevice dev = getLonDevice();
    if(!dev.isUpLoadInProgress()) { dev.initUpload(true); objUploadInProgress=true; }
  }
  private boolean objUploadInProgress = false;
  /** Override point to customize upload process.  This will be called after all device components have been uploaded. */ 
  public void endUpload()
  {
    BLonDevice dev = getLonDevice();
    if(objUploadInProgress) { dev.cleanupUpload(); objUploadInProgress=false; }
  }

  /** Override point to customize download process.  This will be called before the download job is initiated. 
  If a subclass wishes to cancel the download, then a LocalizableRuntimeException should be thrown.*/ 
  public void checkDownload(){}
  /** Override point to customize download process.  This will be called at the beginning of a download operation . */ //after initDownload()
  public void beginDownload()
  {
    BLonDevice dev = getLonDevice();
    // If object download not part of device download then allow randow access
    if(!dev.isDownLoadInProgress()) { dev.initDownload(true); objDownloadInProgress=true; }
  }
  private boolean objDownloadInProgress = false;
  /** Override point to customize download process.  This will be called after all device components have been downloaded. */ 
  public void endDownload()
  {
    BLonDevice dev = getLonDevice();
    if(!dev.isDownLoadInProgress()) { dev.cleanupDownload(); objDownloadInProgress=false; }
  }

  
////////////////////////////////////////////////////////////
//  Visualization
////////////////////////////////////////////////////////////
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.make("module://lonworks/com/tridium/lonworks/ui/icons/objectFolder.png");


}
