/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.device.BLonLearnNvJob;
import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonInterfaceFile;

import java.util.logging.*;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BLearnNvParameters;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.naming.BOrd;
import javax.baja.sys.*;

/**
 * BDynamicDevice adds support to BLonDevice for dynamically create
 * components from the devices self documentation or an xml file.
 *
 * @author    Robert Adams
 * @creation  22 June 01
 * @version   $Revision: 5$ $Date: 10/18/01 2:56:40 PM$
 * @since     Niagara 3.0
 */
public class BDynamicDevice
  extends BLonDevice
{
  /*-

  class BDynamicDevice
  {
    properties
    {
      xmlFile: BOrd
        -- The name of xml file used by importXml action.
        flags { readonly }
        default {[ BOrd.NULL ]}
    }
    actions
    {
      learnNv()
         -- Create/update components from device self documentation
         flags { hidden }
         
      learnNv_(param : BLearnNvParameters) : BOrd
         -- Create/update components from device self documentation
         default {[ new BLearnNvParameters() ]}
         
      trim() 
        -- Remove unlinked/unproxied nvs 
        
      importXml(parm : BImportParameters)
         flags { hidden }
         default {[ new BImportParameters() ]}
    }
    topics
    {
      dynamicOpComplete
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.BDynamicDevice(3225800081)1.0$ @*/
/* Generated Wed Jun 08 11:17:23 EDT 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "xmlFile"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>xmlFile</code> property.
   * The name of xml file used by importXml action.
   * @see javax.baja.lonworks.BDynamicDevice#getXmlFile
   * @see javax.baja.lonworks.BDynamicDevice#setXmlFile
   */
  public static final Property xmlFile = newProperty(Flags.READONLY, BOrd.NULL,null);
  
  /**
   * Get the <code>xmlFile</code> property.
   * @see javax.baja.lonworks.BDynamicDevice#xmlFile
   */
  public BOrd getXmlFile() { return (BOrd)get(xmlFile); }
  
  /**
   * Set the <code>xmlFile</code> property.
   * @see javax.baja.lonworks.BDynamicDevice#xmlFile
   */
  public void setXmlFile(BOrd v) { set(xmlFile,v,null); }

////////////////////////////////////////////////////////////////
// Action "learnNv"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>learnNv</code> action.
   * Create/update components from device self documentation
   * @see javax.baja.lonworks.BDynamicDevice#learnNv()
   */
  public static final Action learnNv = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>learnNv</code> action.
   * @see javax.baja.lonworks.BDynamicDevice#learnNv
   */
  public void learnNv() { invoke(learnNv,null,null); }

////////////////////////////////////////////////////////////////
// Action "learnNv_"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>learnNv_</code> action.
   * Create/update components from device self documentation
   * @see javax.baja.lonworks.BDynamicDevice#learnNv_()
   */
  public static final Action learnNv_ = newAction(0,new BLearnNvParameters(),null);
  
  /**
   * Invoke the <code>learnNv_</code> action.
   * @see javax.baja.lonworks.BDynamicDevice#learnNv_
   */
  public BOrd learnNv_(BLearnNvParameters param) { return (BOrd)invoke(learnNv_,param,null); }

////////////////////////////////////////////////////////////////
// Action "trim"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>trim</code> action.
   * Remove unlinked/unproxied nvs
   * @see javax.baja.lonworks.BDynamicDevice#trim()
   */
  public static final Action trim = newAction(0,null);
  
  /**
   * Invoke the <code>trim</code> action.
   * @see javax.baja.lonworks.BDynamicDevice#trim
   */
  public void trim() { invoke(trim,null,null); }

////////////////////////////////////////////////////////////////
// Action "importXml"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>importXml</code> action.
   * @see javax.baja.lonworks.BDynamicDevice#importXml()
   */
  public static final Action importXml = newAction(Flags.HIDDEN,new BImportParameters(),null);
  
  /**
   * Invoke the <code>importXml</code> action.
   * @see javax.baja.lonworks.BDynamicDevice#importXml
   */
  public void importXml(BImportParameters parm) { invoke(importXml,parm,null); }

////////////////////////////////////////////////////////////////
// Topic "dynamicOpComplete"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>dynamicOpComplete</code> topic.
   * @see javax.baja.lonworks.BDynamicDevice#fireDynamicOpComplete
   */
  public static final Topic dynamicOpComplete = newTopic(0,null);
  
  /**
   * Fire an event for the <code>dynamicOpComplete</code> topic.
   * @see javax.baja.lonworks.BDynamicDevice#dynamicOpComplete
   */
  public void fireDynamicOpComplete(BValue event) { fire(dynamicOpComplete, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDynamicDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////
//  LonDevice api
////////////////////////////////////////////////////////////



  /**
   * Returns true to indicates that programId may be changed
   * during commissioning.
  public boolean programIdChanges() { return true; }
   */

  /**  If there is a non-null xmlFile and no nvs then importXml. */
  public void started()
    throws Exception
  {
    super.started();
    
    if( (getXmlFile()!=BOrd.NULL) && 
        (getNetworkVariables().length==0) && 
        getNeuronIdAddress().isZero() )
    {    
      doImportXml(new BImportParameters(false,getLonNetwork().netmgmt().getUseLonObjects()));
    }  
  }
  
////////////////////////////////////////////////////////////
//  Learn Nvs
////////////////////////////////////////////////////////////
  /**
   * Overridden here to provide the default value for the
   * learnNv action.
   */
  public BValue getActionParameterDefault(Action action)
  {
    if (action == learnNv_)
    {
      BLonNetmgmt nm = getLonNetwork().netmgmt();
      getComponentSpace().update(nm,1);
      return new BLearnNvParameters(nm.getUseLonObjects());
    }
    return super.getActionParameterDefault(action);
  }
  
  /**
   * DEPRECATED
   */
  public void doLearnNv()
  {
    if(getXmlFile()!=BOrd.NULL)
      throw new LocalizableRuntimeException("lonworks","learnNv.block");

    BLearnNvParameters param = new BLearnNvParameters(getLonNetwork().netmgmt().getUseLonObjects());
    new BLonLearnNvJob(getLonNetwork(), this, param).submit(null);
  }
  
  /**
   * Build database representation from devices self documentation. 
   * Use user specified parameters
   */
  public BOrd doLearnNv_(BLearnNvParameters param)
  {
    if(getXmlFile()!=BOrd.NULL)
      throw new LocalizableRuntimeException("lonworks","learnNv.block");

    return new BLonLearnNvJob(getLonNetwork(), this, param).submit(null);
  }

////////////////////////////////////////////////////////////
//  Xml support
////////////////////////////////////////////////////////////

  /**
   * Read the xml file and update device components.  Add nvs,
   * ncis, cps and mtags as needed.
   */
  public void doImportXml(BImportParameters param)
  {
    if(getXmlFile().isNull()) return;
    XLonInterfaceFile root = LonXMLReader.decode(getXmlFile());
    DynaDev.importXLon(this, root, param);
  }
  
  /** Allows specification of log when importing an unmounted DynamicDevice. */
  public final void doImportXml(BImportParameters param, Logger log)
  {
    this.log = log;
    doImportXml(param);
  }
  // This was removed. public void importXLon(XLonInterfaceFile root, BImportParameters param)

  /**
   * Not currently implemented.
   */
  public void doExportXml()
  {
    log().fine("doExportXml not implemented");
  }

 
  /**
   * Remove all nvs that do not have a proxy, are not linked and are not bound.
   */
  public final void doTrim()
  {
    BINetworkVariable[] nvs =  getNetworkVariables();
    for(int i=0 ; i<nvs.length ; i++)
    {
      if(nvs[i]==null || !nvs[i].isNetworkVariable()) continue;
      
      BNetworkVariable nv = (BNetworkVariable)nvs[i];
      BComponent p = (BComponent)nv.getParent();
      Property nvProp = nv.getPropertyInParent();
      BNvConfigData nvCfg = nv.getNvConfigData();
      if( !nv.hasProxies() &&
          !nvCfg.isBoundNv() &&
          ( (nvCfg.isInput() && p.getLinks(nvProp).length==0) ||
            (nvCfg.isOutput() && p.getKnobs(nvProp).length==0) ) ) 
      {
         p.remove(nv);
         log().fine("trim " + getDisplayName(null) + ":" + nv.getDisplayName(null)); 
      }   
    }
  }
}