/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.hx;

import java.io.IOException;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

/**
 * BHxSaveButton.
 *
 * @author    Andy Frank
 * @creation  14 Feb 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxSaveButton
  extends BHxWbCommandButton
  
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxSaveButton INSTANCE = new BHxSaveButton();

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxSaveButton.class);
  
  protected BHxSaveButton() {}
  
  public void handle(BInputEvent event, HxOp op)
    throws IOException
  {
    if (event instanceof BMouseEvent && event.getId() == BMouseEvent.MOUSE_PRESSED)
    {
      BMouseEvent mouseEvent = (BMouseEvent)event;
      if(mouseEvent.isButton1Down())
      {
        HtmlWriter out = op.getHtmlWriter();
        out.w("hx.save();");
      }
    }
  }
}


