/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.hx;

import javax.baja.agent.BIAgent;
import javax.baja.hx.HxOp;
import javax.baja.hx.px.binding.BHxPxBinding;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.UnboundException;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import com.tridium.hx.util.HxUtils;
import com.tridium.kitpx.BIncrementSetPointBinding;

/**
 * @author Lee Adcock
 * @creation 29 Sept 09
 * @version $Revision$ $Date: 9/29/2009 9:51:02 AM$
 * @since Niagara 3.5
 */  
public class BHxPxIncrementBinding
  extends BHxPxBinding
  implements BIAgent
{
  public static final BHxPxIncrementBinding INSTANCE = new BHxPxIncrementBinding();  

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxPxIncrementBinding.class);
  

  public void handle(BInputEvent event, HxOp op)
      throws Exception
  {
    if (event instanceof BMouseEvent && event.getId() == BMouseEvent.MOUSE_PRESSED)
    {
      BMouseEvent mouseEvent = (BMouseEvent)event;
      if(mouseEvent.isButton1Down())
      {
        BIncrementSetPointBinding incrementBinding = (BIncrementSetPointBinding)op.get();
        try
        {
          incrementBinding.getTarget().getComponent().lease();
        } catch (UnboundException ue) {
          return;
        }
        incrementBinding.saveSetPoint(op.getBase());
        HxUtils.forceUpdate(op);
      }
    }
  }
  
}
