/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.hx;

import java.io.Writer;
import javax.baja.agent.BIAgent;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.hx.px.binding.BHxPxBinding;
import javax.baja.hx.px.binding.BHxPxValueBinding;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import com.tridium.kitpx.BActionBinding;

/**
 * @author Lee Adcock on 29 Sept 09
 * @since Niagara 3.5
 */
public class BHxPxActionBinding
  extends BHxPxBinding
  implements BIAgent
{
  public static final BHxPxActionBinding INSTANCE = new BHxPxActionBinding();

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BHxPxActionBinding.class);

  public BHxPxActionBinding()
  {
    registerEvent(invokeActionCommand = new ActionBindingInvokeActionCommand());
  }

  @Override
  public void write(HxOp op)
    throws Exception
  {
    HxOp widgetOp = ((HxOp) op.getBase().getBase());
    BActionBinding actionBinding = (BActionBinding) op.get();
    BHxPxWidget hxPxWidget = BHxPxWidget.makeFor(actionBinding.getWidget());
    MouseEventCommand mouseHandler = hxPxWidget.getMouseEventHandler();

    if (mouseHandler != null && actionBinding.getWidgetEvent().equals("mouseEvent"))
    {
      hxPxWidget.registerEvent(mouseHandler, "mouseEventHandler");

      if (hxPxWidget.isEventRegistered(hxPxWidget.mouseEventCommand))
      {
        Writer writer = HxUtil.startOnloadWriter(op);
        try
        {
          PropertiesCollection events = new PropertiesCollection.Events();
          events.add("onmouseenter", mouseHandler.getInvokeCode(BMouseEvent.MOUSE_ENTERED, widgetOp));
          events.write(widgetOp);
        }
        finally
        {
          HxUtil.finishOnloadWriter(writer, op);
        }
      }
    }
  }

  @Override
  public void handle(BInputEvent event, HxOp op)
    throws Exception
  {
    //When widget event is mouseEvent, mouseEntered will cause the action to fire as specified in NCCB-33341. All other widget events will fire on left mouse press from a browser.
    BActionBinding actionBinding = (BActionBinding) op.get();
    if ((!actionBinding.getWidgetEvent().equals("mouseEvent") && event.getId() == BMouseEvent.MOUSE_PRESSED && ((BMouseEvent) event).isButton1Down()) ||
      (actionBinding.getWidgetEvent().equals("mouseEvent") && event.getId() == BMouseEvent.MOUSE_ENTERED))
    {
      BHxPxValueBinding.handleAction(invokeActionCommand, op);
    }
  }

  @Override
  public boolean process(HxOp op) throws Exception
  {
    if (BHxPxValueBinding.processAction(invokeActionCommand, op))
      return true;

    return super.process(op);
  }

  private static class ActionBindingInvokeActionCommand
    extends BHxPxValueBinding.InvokeActionCommand
  {

    @Override
    public String getActionName(HxOp op)
    {
      try
      {
        BActionBinding actionBinding = (BActionBinding) op.get();
        if(!actionBinding.isBound())
        {
          return null;
        }
        OrdTarget target = actionBinding.getTarget();
        Slot slot = target.getSlotInComponent();
        if(slot != null)
          return slot.getName();
      }
      catch(Exception ignore)  {}
      return null;
    }

    @Override
    public BValue getDefaultActionArgument(HxOp op)
    {
      BActionBinding actionBinding = (BActionBinding) op.get();
      if (!actionBinding.getActionArg().equals(BActionBinding.actionArg.getDefaultValue()))
        return actionBinding.getActionArg();
      else
        return null;
    }
  }

  private BHxPxValueBinding.InvokeActionCommand invokeActionCommand;
}
