/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.sys.BINumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BValueBinding;

/**
 * BSpectrumSetpointBinding may be used in conjunction with a SpecturmBinding
 * animate the setpoint property of the SpectrumBinding itself.
 *
 * @author    Brian Frank       
 * @creation  11 Sept 04
 * @version   $Revision$ $Date: 19-May-04 11:11:24 AM$
 * @since     Baja 1.0
 */
public class BSpectrumSetpointBinding
  extends BValueBinding
{                          

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSpectrumSetpointBinding.class);

  public void targetChanged()
  {                
    if (isBound() && get() instanceof BINumeric)
    {                                          
      double value = ((BINumeric)get()).getNumeric();
      BBinding[] bindings = getWidget().getBindings();
      for(int i=0; i<bindings.length; ++i)
        if (bindings[i] instanceof BSpectrumBinding)
          ((BSpectrumBinding)bindings[i]).setSetpoint(value);
    }    
    super.targetChanged();
  }
          
}
