/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;

/**
 * BSpectrumBinding is used to animate a widget's brush property by
 * mapping a numeric value into a color range defined by by lowColor,
 * midColor, and highColor.
 *
 * @author    Brian Frank       
 * @creation  31 Aug 04
 * @version   $Revision$ $Date: 19-May-04 11:11:24 AM$
 * @since     Baja 1.0
 */
public class BSpectrumBinding
  extends BBinding
{                          
  /*-
  
  class BSpectrumBinding
  {
    properties
    {
      widgetProperty: String
        -- Slot name of widget property to animate
        default {[ "fill" ]}
      lowColor: BColor       
        -- The color to display when bound target is less than setpoint-extent/2
        default {[ BColor.blue ]}
      midColor: BColor
        -- The color to display when bound target is right at setpoint
        default {[ BColor.white ]}
      highColor: BColor
        -- The color to display when bound target is greater than setpoint+extent/2
        default {[ BColor.red ]}
      setpoint: double  
        -- The value to use for the midpoint of the range.  This variable
        -- can be animated using a SpectrumSetpointBinding.
        default {[ 50 ]}
      extent: double
        -- This is the total range of the bound value which maps from low to high.
        default {[ 100 ]}      
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BSpectrumBinding(212143730)1.0$ @*/
/* Generated Sat Sep 11 13:11:45 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "widgetProperty"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>widgetProperty</code> property.
   * Slot name of widget property to animate
   * @see com.tridium.kitpx.BSpectrumBinding#getWidgetProperty
   * @see com.tridium.kitpx.BSpectrumBinding#setWidgetProperty
   */
  public static final Property widgetProperty = newProperty(0, "fill",null);
  
  /**
   * Get the <code>widgetProperty</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#widgetProperty
   */
  public String getWidgetProperty() { return getString(widgetProperty); }
  
  /**
   * Set the <code>widgetProperty</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#widgetProperty
   */
  public void setWidgetProperty(String v) { setString(widgetProperty,v,null); }

////////////////////////////////////////////////////////////////
// Property "lowColor"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lowColor</code> property.
   * The color to display when bound target is less than
   * setpoint-extent/2
   * @see com.tridium.kitpx.BSpectrumBinding#getLowColor
   * @see com.tridium.kitpx.BSpectrumBinding#setLowColor
   */
  public static final Property lowColor = newProperty(0, BColor.blue,null);
  
  /**
   * Get the <code>lowColor</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#lowColor
   */
  public BColor getLowColor() { return (BColor)get(lowColor); }
  
  /**
   * Set the <code>lowColor</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#lowColor
   */
  public void setLowColor(BColor v) { set(lowColor,v,null); }

////////////////////////////////////////////////////////////////
// Property "midColor"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>midColor</code> property.
   * The color to display when bound target is right at
   * setpoint
   * @see com.tridium.kitpx.BSpectrumBinding#getMidColor
   * @see com.tridium.kitpx.BSpectrumBinding#setMidColor
   */
  public static final Property midColor = newProperty(0, BColor.white,null);
  
  /**
   * Get the <code>midColor</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#midColor
   */
  public BColor getMidColor() { return (BColor)get(midColor); }
  
  /**
   * Set the <code>midColor</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#midColor
   */
  public void setMidColor(BColor v) { set(midColor,v,null); }

////////////////////////////////////////////////////////////////
// Property "highColor"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>highColor</code> property.
   * The color to display when bound target is greater than setpoint+extent/2
   * @see com.tridium.kitpx.BSpectrumBinding#getHighColor
   * @see com.tridium.kitpx.BSpectrumBinding#setHighColor
   */
  public static final Property highColor = newProperty(0, BColor.red,null);
  
  /**
   * Get the <code>highColor</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#highColor
   */
  public BColor getHighColor() { return (BColor)get(highColor); }
  
  /**
   * Set the <code>highColor</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#highColor
   */
  public void setHighColor(BColor v) { set(highColor,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpoint</code> property.
   * The value to use for the midpoint of the range.  This
   * variable can be animated using a SpectrumSetpointBinding.
   * @see com.tridium.kitpx.BSpectrumBinding#getSetpoint
   * @see com.tridium.kitpx.BSpectrumBinding#setSetpoint
   */
  public static final Property setpoint = newProperty(0, 50,null);
  
  /**
   * Get the <code>setpoint</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#setpoint
   */
  public double getSetpoint() { return getDouble(setpoint); }
  
  /**
   * Set the <code>setpoint</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#setpoint
   */
  public void setSetpoint(double v) { setDouble(setpoint,v,null); }

////////////////////////////////////////////////////////////////
// Property "extent"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>extent</code> property.
   * This is the total range of the bound value which maps
   * from low to high.
   * @see com.tridium.kitpx.BSpectrumBinding#getExtent
   * @see com.tridium.kitpx.BSpectrumBinding#setExtent
   */
  public static final Property extent = newProperty(0, 100,null);
  
  /**
   * Get the <code>extent</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#extent
   */
  public double getExtent() { return getDouble(extent); }
  
  /**
   * Set the <code>extent</code> property.
   * @see com.tridium.kitpx.BSpectrumBinding#extent
   */
  public void setExtent(double v) { setDouble(extent,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSpectrumBinding.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BBinding
////////////////////////////////////////////////////////////////

  public BValue getOnWidget(Property prop) 
  { 
    if (prop.getName().equals(getWidgetProperty()) && isBound())
    {                                                          
      BObject target = get();
      if (target instanceof BINumeric)
      {
        double value = ((BINumeric)target).getNumeric();
        BColor color = solveColor(value);
        
        if (prop.getType().is(BBrush.TYPE))
          return color.toBrush();
        
        if (prop.getType().is(BColor.TYPE))
          return color;
      }
    }
        
    return super.getOnWidget(prop);
  }   
        
////////////////////////////////////////////////////////////////
// Color Solver
////////////////////////////////////////////////////////////////
  
  /**
   * Solve the color to use for the specified value.
   */
  BColor solveColor(double value)
  {
    int red, blue, green, alpha;
    double mid = getSetpoint();
    double delta = getExtent()/2.0;
    BColor lowColor = getLowColor();
    BColor midColor = getMidColor();
    BColor highColor = getHighColor();

    // solve for the color using a linear equation y = mx + b,
    // the y axis is the value being monitored, and the x
    // axis is the color (red, green, or blue)
    if (value < mid)
    {
      // handle current over boundary
      if (value < mid-delta) return lowColor;

      double mRed = (midColor.getRed() - lowColor.getRed())/delta;
      double bRed = midColor.getRed() - mRed*mid;
      red = (int)(mRed*value + bRed);

      double mGreen = (midColor.getGreen() - lowColor.getGreen())/delta;
      double bGreen = midColor.getGreen() - mGreen*mid;
      green = (int)(mGreen*value + bGreen);

      double mBlue = (midColor.getBlue() - lowColor.getBlue())/delta;
      double bBlue = midColor.getBlue() - mBlue*mid;
      blue = (int)(mBlue*value + bBlue);

      double mAlpha = (midColor.getAlpha() - lowColor.getAlpha())/delta;
      double bAlpha = midColor.getAlpha() - mAlpha*mid;
      alpha = (int)(mAlpha*value + bAlpha);
    }

    else
    {
      // handle current over boundary
      if (value > mid+delta) return highColor;

      double mRed = (highColor.getRed() - midColor.getRed())/delta;
      double bRed = midColor.getRed() - mRed*mid;
      red = (int)(mRed*value + bRed);

      double mGreen = (highColor.getGreen() - midColor.getGreen())/delta;
      double bGreen = midColor.getGreen() - mGreen*mid;
      green = (int)(mGreen*value + bGreen);

      double mBlue = (highColor.getBlue() - midColor.getBlue())/delta;
      double bBlue = midColor.getBlue() - mBlue*mid;
      blue = (int)(mBlue*value + bBlue);

      double mAlpha = (highColor.getAlpha() - midColor.getAlpha())/delta;
      double bAlpha = midColor.getAlpha() - mAlpha*mid;
      alpha = (int)(mAlpha*value + bAlpha);
    }

    return BColor.make(red, green, blue, alpha);
  }  
  
}
