/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.Command;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

/**
 * BLogoffButton automatically integrates with the WbShell's logoff command.
 *
 * @author    Brian Frank
 * @creation  24 Aug 04
 * @version   $Revision$ $Date: 19-May-04 11:11:24 AM$
 * @since     Baja 1.0
 */
public class BLogoffButton
  extends BWbCommandButton
{

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLogoffButton.class);

  public BLogoffButton()
  {
    super(label, BImage.make(icon));
  }

  public Command getWbCommand()
  {
    return ((BWbShell)getShell()).getLogoffCommand();
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("door.png");

  static final String label = UiLexicon.bajaui().getText("commands.logoff.label");
}
