/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BBrush;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import com.tridium.sys.schema.Fw;

/**
 * BGenericFieldEditor is a specialized field editor which wraps
 * a specific BWbFieldEditor created during loadValue() based on the 
 * target object.  It's useful for building weakly typed px forms.
 *
 * @author    Brian Frank       
 * @creation  16 May 02
 * @version   $Revision$ $Date: 18-Dec-03 5:31:54 PM$
 * @since     Baja 1.0
 */
public class BGenericFieldEditor
  extends BWbFieldEditor
{ 

  /*-
  
  class BGenericFieldEditor
  {
    properties
    {
      foreground: BBrush
        -- Brush to use to render the editor foreground.  If set to 
        -- BBrush.NULL then a context sensitive defaults fallback will be 
        -- used.  This property has varying effects depending on what the 
        -- editor is bound to (in some cases it may do nothing at all).
        default {[ BBrush.NULL ]}
      background: BBrush
        -- Brush to use to render the editor background.  If set to 
        -- BBrush.NULL then a context sensitive defaults fallback will be 
        -- used.  This property has varying effects depending on what the 
        -- editor is bound to (in some cases it may do nothing at all).
        default {[ BBrush.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BGenericFieldEditor(1717407952)1.0$ @*/
/* Generated Sat May 14 10:38:36 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "foreground"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>foreground</code> property.
   * Brush to use to render the editor foreground.  If set to BBrush.NULL then a context sensitive defaults fallback will be used.  This property has varying effects depending on what the editor is bound to (in some cases it may do nothing at all).
   * @see com.tridium.kitpx.BGenericFieldEditor#getForeground
   * @see com.tridium.kitpx.BGenericFieldEditor#setForeground
   */
  public static final Property foreground = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>foreground</code> property.
   * @see com.tridium.kitpx.BGenericFieldEditor#foreground
   */
  public BBrush getForeground() { return (BBrush)get(foreground); }
  
  /**
   * Set the <code>foreground</code> property.
   * @see com.tridium.kitpx.BGenericFieldEditor#foreground
   */
  public void setForeground(BBrush v) { set(foreground,v,null); }

////////////////////////////////////////////////////////////////
// Property "background"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>background</code> property.
   * Brush to use to render the editor background.  If set to BBrush.NULL then a context sensitive defaults fallback will be used.  This property has varying effects depending on what the editor is bound to (in some cases it may do nothing at all).
   * @see com.tridium.kitpx.BGenericFieldEditor#getBackground
   * @see com.tridium.kitpx.BGenericFieldEditor#setBackground
   */
  public static final Property background = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>background</code> property.
   * @see com.tridium.kitpx.BGenericFieldEditor#background
   */
  public BBrush getBackground() { return (BBrush)get(background); }
  
  /**
   * Set the <code>background</code> property.
   * @see com.tridium.kitpx.BGenericFieldEditor#background
   */
  public void setBackground(BBrush v) { set(background,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BGenericFieldEditor.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get the actual editor being used inside of the generic wrapper.
   * Return null if an inner editor has not been initialized.
   */
  public BWbFieldEditor getInnerEditor()
  {               
    BWidget content = getContent();
    if (content instanceof BWbFieldEditor)
      return (BWbFieldEditor)content;
    else
      return null;
  }
  
////////////////////////////////////////////////////////////////
// WbEditor
////////////////////////////////////////////////////////////////

  protected void doSetReadonly(boolean readonly)
  {                    
    BWbFieldEditor inner = getInnerEditor();
    if (inner != null) inner.setReadonly(readonly);
  }

  protected void doLoadValue(BObject value, Context context)
    throws Exception
  {
    BWbFieldEditor inner = getInnerEditor();
    if (inner == null || 
        inner.getCurrentValue() == null || 
        inner.getCurrentValue().getClass() != value.getClass())
    {
      inner = makeFor(value, context);
      inner.setReadonly(isReadonly());
      
      // TODO I have seen a deadlock where the add() operation
      // called by this method blocks due to started() [26 Jan 05]
      linkTo(inner, actionPerformed, actionPerformed);
      linkTo(inner, setModified,     setModified);
      
      setContent(inner);
    }
    inner.loadValue(value, context);
    syncColors();
  }

  protected BObject doSaveValue(BObject value, Context cx)
    throws CannotSaveException, Exception
  {
    BWbFieldEditor inner = getInnerEditor();
    if (inner != null) return inner.saveValue(value, cx);
    return value;
  }

////////////////////////////////////////////////////////////////
// Sync
////////////////////////////////////////////////////////////////

  public void changed(Property prop, Context cx)
  {
    if (prop == foreground || prop == background) syncColors();
    super.changed(prop, cx);
  }      
  
  void syncColors()
  {                      
    BWbFieldEditor editor = getInnerEditor();
    if (editor != null)
      editor.fw(Fw.UPDATE_COLORS, getForeground(), getBackground(), null, null);
  }

}

