/*
 * Copyright 2007, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitpx;

import java.util.ArrayList;
import java.util.List;
import javax.baja.gx.Graphics;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BPane;
import javax.baja.util.BFormat;

/**
 * Format pane
 *
 * Processes all child labels 'text' Properties through BFormat and updates them.
 * This is useful if you're translating a Px page with lots of lexicon references as it
 * avoids the need to create lots of bindings.
 * 
 * @author    Gareth Johnson
 * @creation  20 Aug 2007
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public final class BFormatPane extends BPane
{
/*-
  class BFormatPane
  {
    properties
    {
      content: BWidget
        -- Widget content to display inside border.
        default {[ new BNullWidget() ]}  
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BFormatPane(1361038834)1.0$ @*/
/* Generated Tue Jul 28 12:22:27 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "content"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>content</code> property.
   * Widget content to display inside border.
   * @see com.tridium.kitpx.BFormatPane#getContent
   * @see com.tridium.kitpx.BFormatPane#setContent
   */
  public static final Property content = newProperty(0, new BNullWidget(),null);
  
  /**
   * Get the <code>content</code> property.
   * @see com.tridium.kitpx.BFormatPane#content
   */
  public BWidget getContent() { return (BWidget)get(content); }
  
  /**
   * Set the <code>content</code> property.
   * @see com.tridium.kitpx.BFormatPane#content
   */
  public void setContent(BWidget v) { set(content,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFormatPane.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 

  /**
   * Called to start the component
   */
  public void started() throws Exception
  {
    super.started();  
    
    // If we are not running in Px editor mode then process the widgets
    if (!isDesignTime())
    {     
      processWidgets(null);  
    }
  } 
  
  /**
   * Process the widgets
   */
  public void processWidgets(Context cx)
  {
    //
    // Find all of the children
    //
    
    List<BLabel> labels = new ArrayList<>();
    findLabels(this, labels);
    
    //
    // Adjust all of the text on the children
    //

    for (BLabel label : labels)
    {
      label.setText(BFormat.format(label.getText(), this, cx));
    }
  } 
  
  /**
   * Recursive method to find all of the labels
   */
  private void findLabels(BWidget w, List<BLabel> a)
  {
    BWidget[] widgets = w.getChildren(BWidget.class);
    
    for(int i=0; i < widgets.length; ++i)
    {
      if (widgets[i] instanceof BLabel)
        a.add((BLabel) widgets[i]);
      
      findLabels(widgets[i], a);
    }
  }
 
////////////////////////////////////////////////////////////////
// Layout
////////////////////////////////////////////////////////////////

  public void computePreferredSize()
  {
    BWidget c = getContent(); 
    c.computePreferredSize();
    setPreferredSize(c.getPreferredWidth(), c.getPreferredHeight()); 
  }

  public void doLayout(BWidget[] kids)
  {
    double w = getWidth(), h = getHeight();
    BWidget c = getContent(); 
    c.setBounds(0,0,w,h);    
  }  
  
  public void paint(Graphics g)
  {               
    if (isVisible() && getContent().isVisible())
      paintChild(g, getContent());
  }
}
