/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.ui;

import java.util.*;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.util.*;
import javax.baja.ui.*;
import javax.baja.ui.enums.*;
import javax.baja.ui.pane.*;
import javax.baja.ui.util.*;
import javax.baja.workbench.fieldeditor.*;

import com.tridium.workbench.fieldeditors.*;
/**
 * BPropagateFlagsFE allows viewing and editing of a BProgagateFlags.
 *
 * @author    Andy Saunders       
 * @creation  3 Aug 04
 * @version   $Revision: 5$ $Date: 6/17/2004 2:13:14 PM$
 * @since     Baja 1.0
 */
public class BPropagateFlagsFE
  extends BWbFieldEditor 
  implements Comparator<Object>
{ 

////////////////////////////////////////////////////////////////
// Type 
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPropagateFlagsFE.class);

////////////////////////////////////////////////////////////////
// BWbEditor
////////////////////////////////////////////////////////////////
  protected void doSetReadonly(boolean readonly)
  {
    rebuild();
  }  

  protected void doLoadValue(BObject value, Context cx)
  {          
    this.status = (BStatus)value;
    rebuild();
  }
  
  protected BObject doSaveValue(BObject value, Context cx)
  {
    int bits = 0;
    for(int i=0; i<items.length; ++i)
      bits = items[i].save(bits);
    return BStatus.make(bits);
  }

////////////////////////////////////////////////////////////////
// Build
////////////////////////////////////////////////////////////////

  private void rebuild()
  {
    // if readonly then just use a text field
    if (isReadonly())
    {                                                       
      String str = status.toString();                   
      
      // if already created just update text
      if (getContent() instanceof BTextField)
      {
        BTextField text = (BTextField)getContent();
        text.setText(str);
      }                                     
      
      // other create text field
      else
      {                
        int len = Math.max(str.length(), 20);
        BTextField text = new BTextField(str, len, false);
        setContent(text);
      }      
      
      items = null;
      return;
    }                           
    
    // alloc a checkbox for each bit if not initialized yet
    if (items == null)
    {
      int[] ordinals = BStatus.ok.getOrdinals();
      items = new Item[ordinals.length];
      for(int i=0; i<items.length; ++i)
        items[i] = new Item(ordinals[i]);

      SortUtil.sort(items, items, this);
      
      BGridPane pane = new BGridPane(items.length);
      for(int i=0; i<items.length; ++i)
      {         
        Item item = items[i];
        pane.add("c"+i, item.checkBox);
        linkTo("lk"+i, item.checkBox, BCheckBox.actionPerformed, setModified);
      }
        
      setContent(pane);
    }               
    
    // load each bit  
    for(int i=0; i<items.length; ++i)
      items[i].load(status.getBits());
  }                
  
  public int compare(Object x, Object y)
  {                        
    Item a = (Item)x;
    Item b = (Item)y;
    if (a.ordinal < b.ordinal) return -1;
    if (a.ordinal == b.ordinal) return 0;
    return 1;
  }
  
////////////////////////////////////////////////////////////////
// Item
////////////////////////////////////////////////////////////////

  class Item
  {                    
    Item(int ordinal)
    {
      this.ordinal = ordinal;
      this.checkBox = new BCheckBox(BStatus.ok.getDisplayTag(ordinal, null));
      if( (ordinal & (BStatus.UNACKED_ALARM | BStatus.NULL | BStatus.STALE)) != 0 )
        this.checkBox.setEnabled(false);
    }                                                                        
    
    void load(int bits)
    {    
      checkBox.setSelected((bits & ordinal) != 0);
    }

    int save(int bits)
    {
      if (checkBox.isSelected())
        bits |= ordinal;
      else
        bits &= ~ordinal;
      return bits;
    }
    
    int ordinal;
    BCheckBox checkBox;

  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
    
  private Item[] items;   
  private BStatus status = BStatus.ok;
}
