/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.ui;

import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.kitControl.BDiscreteTotalizerAlarmAlgorithm;
import com.tridium.kitControl.BExtensionName;
import com.tridium.workbench.fieldeditors.BComponentNamePickerFE;

//import javax.baja.status.*;
//import javax.baja.ui.*;
//import javax.baja.ui.list.*;
//import javax.baja.ui.pane.*;
//import javax.baja.ui.enums.*;
//import javax.baja.workbench.fieldeditor.*;
//import javax.baja.workbench.*;
//import com.tridium.fox.sys.*;

/**
 * Plugin for BString when used select a Descrete Totalizer.
 *
 * @author    Andy Saunders
 * @creation  24 Nov 2004
 * @version   $Revision$ $Date: 8/16/2004 6:23:19 PM$
 * @since     Baja 1.0
 */
public class BDiscreteTotalizerChooserFE
  extends BComponentNamePickerFE//BWbFieldEditor
{ 

////////////////////////////////////////////////////////////////
// BObject 
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDiscreteTotalizerChooserFE.class);

////////////////////////////////////////////////////////////////
// BPlugin
////////////////////////////////////////////////////////////////
  

  protected void doLoadValue(BObject value, Context cx)
  {
    extensionName = (BExtensionName)value; 
    alarmAlg = (BDiscreteTotalizerAlarmAlgorithm) extensionName.getParent();
    loadName(extensionName.getExtensionName());
  }
  
  protected BObject doSaveValue(BObject value, Context cx)
  {
    extensionName.setExtensionName(saveName());
    return extensionName;
  }
  

  public BComponent[] list()
    throws Exception
  {
    BControlPoint point = alarmAlg.getParentPoint();
    if(point == null) return null;
    return (BComponent[])(point.getChildren( BDiscreteTotalizerExt.class ));
  }

  BDiscreteTotalizerAlarmAlgorithm alarmAlg;
  BExtensionName extensionName;
}
