/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringLatch is used to latch a string value on the rising edge of the Clock property.
 *
 * @author    Andy Saunders
 * @creation  16 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BStringLatch
  extends BLatch
  implements BIStatus
{  

  /*-
  
  class BStringLatch
  {
    properties
    {
      out: BStatusString
        flags { operator, readonly, transient, summary }
        default {[ new BStatusString() ]}
        
      in: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringLatch(489338789)1.0$ @*/
/* Generated Fri Apr 16 16:44:52 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringLatch#getOut
   * @see com.tridium.kitControl.util.BStringLatch#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringLatch#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringLatch#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringLatch#getIn
   * @see com.tridium.kitControl.util.BStringLatch#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringLatch#in
   */
  public BStatusString getIn() { return (BStatusString)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringLatch#in
   */
  public void setIn(BStatusString v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringLatch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Get the control output value.
   */
  public final void setOutStatusValue(BStatusValue value) 
  { 
    setOut((BStatusString)value);
  }

  public final BStatusValue getInStatusValue() 
  { 
    return (BStatusValue)(getIn().newCopy());
  }

  public String toString(Context cx) { return getOut().toString(cx); }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/stringPoint.png");


}
