/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringConcat is a component that converts a float to a statusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStringConcat
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BStringConcat
  {
    properties
    {
      
      out: BStatusString
        flags { transient, summary }
        default {[ new BStatusString() ]}
        
      inA: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

      inB: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

      inC: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

      inD: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringConcat(2740595880)1.0$ @*/
/* Generated Fri Apr 16 16:26:32 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#getOut
   * @see com.tridium.kitControl.util.BStringConcat#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#getInA
   * @see com.tridium.kitControl.util.BStringConcat#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inA
   */
  public BStatusString getInA() { return (BStatusString)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inA
   */
  public void setInA(BStatusString v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#getInB
   * @see com.tridium.kitControl.util.BStringConcat#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inB
   */
  public BStatusString getInB() { return (BStatusString)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inB
   */
  public void setInB(BStatusString v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#getInC
   * @see com.tridium.kitControl.util.BStringConcat#setInC
   */
  public static final Property inC = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inC
   */
  public BStatusString getInC() { return (BStatusString)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inC
   */
  public void setInC(BStatusString v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#getInD
   * @see com.tridium.kitControl.util.BStringConcat#setInD
   */
  public static final Property inD = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inD
   */
  public BStatusString getInD() { return (BStatusString)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BStringConcat#inD
   */
  public void setInD(BStatusString v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringConcat.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStringConcat()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    calculate();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == inA || p == inB || p == inC || p == inD)
    {
      calculate();
    }
  }

  void calculate()
  {
    String working = "";
    if(getInA().getStatus().isValid())
      working = getInA().getValue();
    if(getInB().getStatus().isValid())
      working = working + getInB().getValue();
    if(getInC().getStatus().isValid())
      working = working + getInC().getValue();
    if(getInD().getStatus().isValid())
      working = working + getInD().getValue();

    getOut().setValue( working );
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
