/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStatusDemux will decode the status flags of
 *   its inputs and expose as individual StatusBoolean
 *   outputs. 
 *
 * @author    Andy Saunders
 * @creation  6 Aug 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BStatusDemux
  extends BComponent
{ 

  /*-
  
  class BStatusDemux
  {
    properties
    {
      inStatus: BStatus
      flags { operator, transient }
      default {[ BStatus.make(0) ]}
        
      inBoolean: BStatusBoolean
        flags { operator, transient }
        default {[ new BStatusBoolean() ]}
        
      inEnum: BStatusEnum
        flags { operator, transient }
        default {[ new BStatusEnum() ]}
        
      inNumeric: BStatusNumeric
        flags { operator, transient }
        default {[ new BStatusNumeric() ]}
        
      inString: BStatusString
        flags { operator, transient }
        default {[ new BStatusString() ]}
        
      alarm: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      down: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      fault: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      nullStatus:  BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      disabled: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      overridden: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      unackedAlarm: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
      stale: BStatusBoolean
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
      
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStatusDemux(3176013373)1.0$ @*/
/* Generated Tue Dec 21 15:53:45 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inStatus"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inStatus</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getInStatus
   * @see com.tridium.kitControl.util.BStatusDemux#setInStatus
   */
  public static final Property inStatus = newProperty(Flags.OPERATOR|Flags.TRANSIENT, BStatus.make(0),null);
  
  /**
   * Get the <code>inStatus</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inStatus
   */
  public BStatus getInStatus() { return (BStatus)get(inStatus); }
  
  /**
   * Set the <code>inStatus</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inStatus
   */
  public void setInStatus(BStatus v) { set(inStatus,v,null); }

////////////////////////////////////////////////////////////////
// Property "inBoolean"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inBoolean</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getInBoolean
   * @see com.tridium.kitControl.util.BStatusDemux#setInBoolean
   */
  public static final Property inBoolean = newProperty(Flags.OPERATOR|Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inBoolean</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inBoolean
   */
  public BStatusBoolean getInBoolean() { return (BStatusBoolean)get(inBoolean); }
  
  /**
   * Set the <code>inBoolean</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inBoolean
   */
  public void setInBoolean(BStatusBoolean v) { set(inBoolean,v,null); }

////////////////////////////////////////////////////////////////
// Property "inEnum"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inEnum</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getInEnum
   * @see com.tridium.kitControl.util.BStatusDemux#setInEnum
   */
  public static final Property inEnum = newProperty(Flags.OPERATOR|Flags.TRANSIENT, new BStatusEnum(),null);
  
  /**
   * Get the <code>inEnum</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inEnum
   */
  public BStatusEnum getInEnum() { return (BStatusEnum)get(inEnum); }
  
  /**
   * Set the <code>inEnum</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inEnum
   */
  public void setInEnum(BStatusEnum v) { set(inEnum,v,null); }

////////////////////////////////////////////////////////////////
// Property "inNumeric"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inNumeric</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getInNumeric
   * @see com.tridium.kitControl.util.BStatusDemux#setInNumeric
   */
  public static final Property inNumeric = newProperty(Flags.OPERATOR|Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inNumeric</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inNumeric
   */
  public BStatusNumeric getInNumeric() { return (BStatusNumeric)get(inNumeric); }
  
  /**
   * Set the <code>inNumeric</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inNumeric
   */
  public void setInNumeric(BStatusNumeric v) { set(inNumeric,v,null); }

////////////////////////////////////////////////////////////////
// Property "inString"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inString</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getInString
   * @see com.tridium.kitControl.util.BStatusDemux#setInString
   */
  public static final Property inString = newProperty(Flags.OPERATOR|Flags.TRANSIENT, new BStatusString(),null);
  
  /**
   * Get the <code>inString</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inString
   */
  public BStatusString getInString() { return (BStatusString)get(inString); }
  
  /**
   * Set the <code>inString</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#inString
   */
  public void setInString(BStatusString v) { set(inString,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarm</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getAlarm
   * @see com.tridium.kitControl.util.BStatusDemux#setAlarm
   */
  public static final Property alarm = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>alarm</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#alarm
   */
  public BStatusBoolean getAlarm() { return (BStatusBoolean)get(alarm); }
  
  /**
   * Set the <code>alarm</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#alarm
   */
  public void setAlarm(BStatusBoolean v) { set(alarm,v,null); }

////////////////////////////////////////////////////////////////
// Property "down"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>down</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getDown
   * @see com.tridium.kitControl.util.BStatusDemux#setDown
   */
  public static final Property down = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>down</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#down
   */
  public BStatusBoolean getDown() { return (BStatusBoolean)get(down); }
  
  /**
   * Set the <code>down</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#down
   */
  public void setDown(BStatusBoolean v) { set(down,v,null); }

////////////////////////////////////////////////////////////////
// Property "fault"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fault</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getFault
   * @see com.tridium.kitControl.util.BStatusDemux#setFault
   */
  public static final Property fault = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>fault</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#fault
   */
  public BStatusBoolean getFault() { return (BStatusBoolean)get(fault); }
  
  /**
   * Set the <code>fault</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#fault
   */
  public void setFault(BStatusBoolean v) { set(fault,v,null); }

////////////////////////////////////////////////////////////////
// Property "nullStatus"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nullStatus</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getNullStatus
   * @see com.tridium.kitControl.util.BStatusDemux#setNullStatus
   */
  public static final Property nullStatus = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>nullStatus</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#nullStatus
   */
  public BStatusBoolean getNullStatus() { return (BStatusBoolean)get(nullStatus); }
  
  /**
   * Set the <code>nullStatus</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#nullStatus
   */
  public void setNullStatus(BStatusBoolean v) { set(nullStatus,v,null); }

////////////////////////////////////////////////////////////////
// Property "disabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>disabled</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getDisabled
   * @see com.tridium.kitControl.util.BStatusDemux#setDisabled
   */
  public static final Property disabled = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>disabled</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#disabled
   */
  public BStatusBoolean getDisabled() { return (BStatusBoolean)get(disabled); }
  
  /**
   * Set the <code>disabled</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#disabled
   */
  public void setDisabled(BStatusBoolean v) { set(disabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "overridden"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>overridden</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getOverridden
   * @see com.tridium.kitControl.util.BStatusDemux#setOverridden
   */
  public static final Property overridden = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>overridden</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#overridden
   */
  public BStatusBoolean getOverridden() { return (BStatusBoolean)get(overridden); }
  
  /**
   * Set the <code>overridden</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#overridden
   */
  public void setOverridden(BStatusBoolean v) { set(overridden,v,null); }

////////////////////////////////////////////////////////////////
// Property "unackedAlarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unackedAlarm</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getUnackedAlarm
   * @see com.tridium.kitControl.util.BStatusDemux#setUnackedAlarm
   */
  public static final Property unackedAlarm = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>unackedAlarm</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#unackedAlarm
   */
  public BStatusBoolean getUnackedAlarm() { return (BStatusBoolean)get(unackedAlarm); }
  
  /**
   * Set the <code>unackedAlarm</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#unackedAlarm
   */
  public void setUnackedAlarm(BStatusBoolean v) { set(unackedAlarm,v,null); }

////////////////////////////////////////////////////////////////
// Property "stale"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stale</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#getStale
   * @see com.tridium.kitControl.util.BStatusDemux#setStale
   */
  public static final Property stale = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>stale</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#stale
   */
  public BStatusBoolean getStale() { return (BStatusBoolean)get(stale); }
  
  /**
   * Set the <code>stale</code> property.
   * @see com.tridium.kitControl.util.BStatusDemux#stale
   */
  public void setStale(BStatusBoolean v) { set(stale,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusDemux.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  public void started()
  {
  }

  public void changed(Property property, Context context) 
  {
    if(isRunning())
    {
      if( property.getName().startsWith("in") )
      {
        calculate();
      }
    }
  }

  /**
   * Default implementation is to do nothing.
   */
  public void calculate()
  {
    checkLinks();
    int statusBits = getInStatus().getBits();
    statusBits     = statusBits | getInBoolean().getStatus().getBits();
    statusBits     = statusBits | getInEnum().getStatus().getBits();
    statusBits     = statusBits | getInNumeric().getStatus().getBits();
    statusBits     = statusBits | getInString().getStatus().getBits();

    BStatus status = BStatus.make(statusBits);

    getAlarm()       .setValue(status.isAlarm()       );
    getFault()       .setValue(status.isFault()       );
    getOverridden()  .setValue(status.isOverridden());
    getDisabled()    .setValue(status.isDisabled());
    getNullStatus()  .setValue(status.isNull()        );
    getUnackedAlarm().setValue(status.isUnackedAlarm());
    getDown()        .setValue(status.isDown()        );
    getStale()       .setValue(status.isStale()       );
  }

  void checkLinks()
  {
    BLink[] links = getLinks(getSlot("inNumeric"));
    if(links.length == 0)
      setInNumeric(newNumeric);
    links = getLinks(getSlot("inBoolean"));
    if(links.length == 0)
      setInBoolean(newBoolean);
    links = getLinks(getSlot("inEnum"));
    if(links.length == 0)
      setInEnum(newEnum);
    links = getLinks(getSlot("inString"));
    if(links.length == 0)
      setInString(newString);
    links = getLinks(getSlot("inStatus"));
    if(links.length == 0)
      setInStatus(BStatus.make(0));
  }



////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

  private BStatusBoolean newBoolean = new BStatusBoolean(false);
  private BStatusEnum    newEnum = new BStatusEnum();
  private BStatusNumeric newNumeric = new BStatusNumeric(0f);
  private BStatusString  newString = new BStatusString("");

}
