/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BRandom generates a random numer.
 *
 *  out = random() * multiplier + offset
 *    where random() is a random number >= 0.0 and < 1.0
 *
 * @author    Andy Saunders
 * @creation  18 Oct 00
 * @version   $Revision: 46$ $Date: 5/11/2004 11:30:56 AM$
 * @since     Niagara 3.0
 */
public class BRandom
  extends BNumericPoint
{  

  /*-
  
  class BRandom
  {
    properties
    {
      multiplier: double
        -- Multiplier is multiplied by the random number generated
        -- which is >= 0.0 but < 1.0 
        default {[ 1.0 ]}
      offset: double
        -- Offset is the positive or negative distance
        -- from zero that the wave's amplitude is 
        -- centered on.
        default {[ 50 ]}
      updateInterval: BRelTime
        -- Update interval specifies how long between
        -- output changes.  
        default {[ BRelTime.make(1000) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BRandom(3794564965)1.0$ @*/
/* Generated Wed Apr 20 08:33:25 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "multiplier"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>multiplier</code> property.
   * Multiplier is multiplied by the random number generated
   * which is >= 0.0 but < 1.0
   * @see com.tridium.kitControl.util.BRandom#getMultiplier
   * @see com.tridium.kitControl.util.BRandom#setMultiplier
   */
  public static final Property multiplier = newProperty(0, 1.0,null);
  
  /**
   * Get the <code>multiplier</code> property.
   * @see com.tridium.kitControl.util.BRandom#multiplier
   */
  public double getMultiplier() { return getDouble(multiplier); }
  
  /**
   * Set the <code>multiplier</code> property.
   * @see com.tridium.kitControl.util.BRandom#multiplier
   */
  public void setMultiplier(double v) { setDouble(multiplier,v,null); }

////////////////////////////////////////////////////////////////
// Property "offset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offset</code> property.
   * Offset is the positive or negative distance from zero
   * that the wave's amplitude is centered on.
   * @see com.tridium.kitControl.util.BRandom#getOffset
   * @see com.tridium.kitControl.util.BRandom#setOffset
   */
  public static final Property offset = newProperty(0, 50,null);
  
  /**
   * Get the <code>offset</code> property.
   * @see com.tridium.kitControl.util.BRandom#offset
   */
  public double getOffset() { return getDouble(offset); }
  
  /**
   * Set the <code>offset</code> property.
   * @see com.tridium.kitControl.util.BRandom#offset
   */
  public void setOffset(double v) { setDouble(offset,v,null); }

////////////////////////////////////////////////////////////////
// Property "updateInterval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>updateInterval</code> property.
   * Update interval specifies how long between output changes.
   * @see com.tridium.kitControl.util.BRandom#getUpdateInterval
   * @see com.tridium.kitControl.util.BRandom#setUpdateInterval
   */
  public static final Property updateInterval = newProperty(0, BRelTime.make(1000),null);
  
  /**
   * Get the <code>updateInterval</code> property.
   * @see com.tridium.kitControl.util.BRandom#updateInterval
   */
  public BRelTime getUpdateInterval() { return (BRelTime)get(updateInterval); }
  
  /**
   * Set the <code>updateInterval</code> property.
   * @see com.tridium.kitControl.util.BRandom#updateInterval
   */
  public void setUpdateInterval(BRelTime v) { set(updateInterval,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRandom.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Update
////////////////////////////////////////////////////////////////
  
  public void started()
    throws Exception
  {            
    super.started();
    initTimer();
  }
  
  public void stopped()
    throws Exception
  {
    if (ticket != null) ticket.cancel();
    super.stopped();
  }
  
  private void initTimer()
  {
    if (ticket != null) ticket.cancel();
    ticket = Clock.schedulePeriodically(this, getUpdateInterval(), execute, null);
  }
  
  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    if (prop == updateInterval) 
    {
      if(getUpdateInterval().getMillis() < 1000)
        setUpdateInterval(BRelTime.make(1000));
      if(isRunning()) initTimer();
    }
  }
  
  public void onExecute(BStatusValue o, Context cx)
  {
    // get the angle per millisecond into one period
    double multiplier = getMultiplier();
    double offset    = getOffset();
    double value     = Math.random()*multiplier + offset;
    
    // update output
    BStatusNumeric out = (BStatusNumeric)o;
    out.setValue(value);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/sine.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  

  private long start;
  private Clock.Ticket ticket;
  
}
