/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BRamp generates a 'sawtooth' ramp function
 *
 * @author    Mike Jarmy
 * @creation  23 Oct 03
 * @version   $Revision: 5$ $Date: 5/11/2004 11:30:51 AM$
 * @since     Niagara 3.0
 */
public class BRamp
  extends BNumericPoint
{  

  /*-
  
  class BRamp
  {
    properties
    {
      enabled: boolean
        -- Enabled will set the output on or off.
        default{[ true ]}
      period: BRelTime
        -- Period is the length of time it takes to 
        -- output one complete cycle of the ramp.
        default {[ BRelTime.make(30000) ]}  
      amplitude: double
        -- Amplitude is height of the ramp from
        -- its lowest to highest point.
        default {[ 50 ]}
      offset: double
        -- Offset is the positive or negative distance
        -- from zero that the ramp's amplitude is 
        -- centered on.
        default {[ 50 ]}
      updateInterval: BRelTime
        -- Update interval specifies how long between
        -- output changes.  A smaller value results in
        -- a more accurate ramp with more changes
        -- per second, while a larger value results in
        -- less precision but with less overhead.
        default {[ BRelTime.make(1000) ]}
      waveform: BRampWaveform
        default {[ BRampWaveform.triangle ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BRamp(3360229131)1.0$ @*/
/* Generated Wed Jan 04 14:27:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "enabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enabled</code> property.
   * Enabled will set the output on or off.
   * @see com.tridium.kitControl.util.BRamp#getEnabled
   * @see com.tridium.kitControl.util.BRamp#setEnabled
   */
  public static final Property enabled = newProperty(0, true,null);
  
  /**
   * Get the <code>enabled</code> property.
   * Enabled will set the output on or off.
   * @see com.tridium.kitControl.util.BRamp#enabled
   */
  public boolean getEnabled() { return getBoolean(enabled); }
  
  /**
   * Set the <code>enabled</code> property.
   * Enabled will set the output on or off.
   * @see com.tridium.kitControl.util.BRamp#enabled
   */
  public void setEnabled(boolean v) { setBoolean(enabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "period"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>period</code> property.
   * Period is the length of time it takes to output one
   * complete cycle of the ramp.
   * @see com.tridium.kitControl.util.BRamp#getPeriod
   * @see com.tridium.kitControl.util.BRamp#setPeriod
   */
  public static final Property period = newProperty(0, BRelTime.make(30000),null);
  
  /**
   * Get the <code>period</code> property.
   * Period is the length of time it takes to output one
   * complete cycle of the ramp.
   * @see com.tridium.kitControl.util.BRamp#period
   */
  public BRelTime getPeriod() { return (BRelTime)get(period); }
  
  /**
   * Set the <code>period</code> property.
   * Period is the length of time it takes to output one
   * complete cycle of the ramp.
   * @see com.tridium.kitControl.util.BRamp#period
   */
  public void setPeriod(BRelTime v) { set(period,v,null); }

////////////////////////////////////////////////////////////////
// Property "amplitude"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>amplitude</code> property.
   * Amplitude is height of the ramp from its lowest to
   * highest point.
   * @see com.tridium.kitControl.util.BRamp#getAmplitude
   * @see com.tridium.kitControl.util.BRamp#setAmplitude
   */
  public static final Property amplitude = newProperty(0, 50,null);
  
  /**
   * Get the <code>amplitude</code> property.
   * Amplitude is height of the ramp from its lowest to
   * highest point.
   * @see com.tridium.kitControl.util.BRamp#amplitude
   */
  public double getAmplitude() { return getDouble(amplitude); }
  
  /**
   * Set the <code>amplitude</code> property.
   * Amplitude is height of the ramp from its lowest to
   * highest point.
   * @see com.tridium.kitControl.util.BRamp#amplitude
   */
  public void setAmplitude(double v) { setDouble(amplitude,v,null); }

////////////////////////////////////////////////////////////////
// Property "offset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offset</code> property.
   * Offset is the positive or negative distance from zero
   * that the ramp's amplitude is centered on.
   * @see com.tridium.kitControl.util.BRamp#getOffset
   * @see com.tridium.kitControl.util.BRamp#setOffset
   */
  public static final Property offset = newProperty(0, 50,null);
  
  /**
   * Get the <code>offset</code> property.
   * Offset is the positive or negative distance from zero
   * that the ramp's amplitude is centered on.
   * @see com.tridium.kitControl.util.BRamp#offset
   */
  public double getOffset() { return getDouble(offset); }
  
  /**
   * Set the <code>offset</code> property.
   * Offset is the positive or negative distance from zero
   * that the ramp's amplitude is centered on.
   * @see com.tridium.kitControl.util.BRamp#offset
   */
  public void setOffset(double v) { setDouble(offset,v,null); }

////////////////////////////////////////////////////////////////
// Property "updateInterval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>updateInterval</code> property.
   * Update interval specifies how long between output changes.  A smaller value results in a more accurate ramp with more changes per second, while a larger value results in less precision but with less overhead.
   * @see com.tridium.kitControl.util.BRamp#getUpdateInterval
   * @see com.tridium.kitControl.util.BRamp#setUpdateInterval
   */
  public static final Property updateInterval = newProperty(0, BRelTime.make(1000),null);
  
  /**
   * Get the <code>updateInterval</code> property.
   * Update interval specifies how long between output changes.  A smaller value results in a more accurate ramp with more changes per second, while a larger value results in less precision but with less overhead.
   * @see com.tridium.kitControl.util.BRamp#updateInterval
   */
  public BRelTime getUpdateInterval() { return (BRelTime)get(updateInterval); }
  
  /**
   * Set the <code>updateInterval</code> property.
   * Update interval specifies how long between output changes.  A smaller value results in a more accurate ramp with more changes per second, while a larger value results in less precision but with less overhead.
   * @see com.tridium.kitControl.util.BRamp#updateInterval
   */
  public void setUpdateInterval(BRelTime v) { set(updateInterval,v,null); }

////////////////////////////////////////////////////////////////
// Property "waveform"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>waveform</code> property.
   * @see com.tridium.kitControl.util.BRamp#getWaveform
   * @see com.tridium.kitControl.util.BRamp#setWaveform
   */
  public static final Property waveform = newProperty(0, BRampWaveform.triangle,null);
  
  /**
   * Get the <code>waveform</code> property.
   * @see com.tridium.kitControl.util.BRamp#waveform
   */
  public BRampWaveform getWaveform() { return (BRampWaveform)get(waveform); }
  
  /**
   * Set the <code>waveform</code> property.
   * @see com.tridium.kitControl.util.BRamp#waveform
   */
  public void setWaveform(BRampWaveform v) { set(waveform,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRamp.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Update
////////////////////////////////////////////////////////////////
  
  public void started()
    throws Exception
  {                 
    super.started();
    execute();
    initTimer();
  }
  
  public void stopped()
    throws Exception
  {
    if (ticket != null) ticket.cancel();
    super.stopped();
  }
  
  private void initTimer()
  {
    if (ticket != null) ticket.cancel();
    //BAbsTime now = Clock.time();
    start = Clock.ticks();
    if (getEnabled()) ticket = Clock.schedulePeriodically(this, getUpdateInterval(), execute, null);
  }
  
  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    if (prop == updateInterval || prop == enabled) 
    {
      if(getUpdateInterval().getMillis() < 1000)
        setUpdateInterval(BRelTime.make(1000));
      if(isRunning()) initTimer();
    }
  }
  
  public void onExecute(BStatusValue o, Context cx)
  {
    if (getEnabled())
    {
      // Set the Status bit on the output
      o.setStatus(BStatus.makeDisabled(o.getStatus(), false));

      // get the millis into the current period
      long period = getPeriod().getMillis();
      long runtime = Clock.ticks() - start;
      long millisIntoPeriod = runtime % period;
      double periodPercent = (double)millisIntoPeriod / (double)period;
  
      // compute the current ramp value
      double amplitude = getAmplitude();
      double offset    = getOffset();
      double value;
      switch(getWaveform().getOrdinal())
      {
        case BRampWaveform.TRIANGLE:
          value = offset - amplitude + 
          (((periodPercent < 0.5) ?
            (amplitude * periodPercent) :
            (amplitude * (1 - periodPercent))) * 4);
          break;
        case BRampWaveform.SAW_TOOTH:
          value = offset - amplitude + (amplitude * periodPercent * 2);
          break;
        case BRampWaveform.INVERTED_SAW_TOOTH:
          value = offset - amplitude + (amplitude * (1-periodPercent) * 2);
          break;
        default:
          throw new IllegalStateException();
      }
  
      // update output
      BStatusNumeric out = (BStatusNumeric)o;
      out.setValue(value);
    }
    else
    {
      o.setStatus(BStatus.makeDisabled(o.getStatus(), true));
    }
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/sine.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  

  private long start;
  private Clock.Ticket ticket;
  
}
