/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.util.*;

import com.tridium.kitControl.*;

/**
 * BNumericSwitch uses a boolean to switch between two numerics.
 *
 * @author    Brian Frank
 * @creation  4 Sept 01
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BNumericSwitch
  extends BKitNumericPoint
{  

  /*-
  
  class BNumericSwitch
  {
    properties
    {
      inSwitch: BStatusBoolean
        -- Value to control which input to output.
        flags { summary }
        default {[ new BStatusBoolean(false) ]}
      inTrue: BStatusNumeric
        -- Value to output when in inSwitch is true.
        flags { summary }
        default {[ new BStatusNumeric() ]}
      inFalse: BStatusNumeric
        -- Value to output when in inSwitch is false.
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BNumericSwitch(3178450764)1.0$ @*/
/* Generated Tue Nov 23 09:57:45 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inSwitch"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inSwitch</code> property.
   * Value to control which input to output.
   * @see com.tridium.kitControl.util.BNumericSwitch#getInSwitch
   * @see com.tridium.kitControl.util.BNumericSwitch#setInSwitch
   */
  public static final Property inSwitch = newProperty(Flags.SUMMARY, new BStatusBoolean(false),null);
  
  /**
   * Get the <code>inSwitch</code> property.
   * @see com.tridium.kitControl.util.BNumericSwitch#inSwitch
   */
  public BStatusBoolean getInSwitch() { return (BStatusBoolean)get(inSwitch); }
  
  /**
   * Set the <code>inSwitch</code> property.
   * @see com.tridium.kitControl.util.BNumericSwitch#inSwitch
   */
  public void setInSwitch(BStatusBoolean v) { set(inSwitch,v,null); }

////////////////////////////////////////////////////////////////
// Property "inTrue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inTrue</code> property.
   * Value to output when in inSwitch is true.
   * @see com.tridium.kitControl.util.BNumericSwitch#getInTrue
   * @see com.tridium.kitControl.util.BNumericSwitch#setInTrue
   */
  public static final Property inTrue = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inTrue</code> property.
   * @see com.tridium.kitControl.util.BNumericSwitch#inTrue
   */
  public BStatusNumeric getInTrue() { return (BStatusNumeric)get(inTrue); }
  
  /**
   * Set the <code>inTrue</code> property.
   * @see com.tridium.kitControl.util.BNumericSwitch#inTrue
   */
  public void setInTrue(BStatusNumeric v) { set(inTrue,v,null); }

////////////////////////////////////////////////////////////////
// Property "inFalse"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inFalse</code> property.
   * Value to output when in inSwitch is false.
   * @see com.tridium.kitControl.util.BNumericSwitch#getInFalse
   * @see com.tridium.kitControl.util.BNumericSwitch#setInFalse
   */
  public static final Property inFalse = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inFalse</code> property.
   * @see com.tridium.kitControl.util.BNumericSwitch#inFalse
   */
  public BStatusNumeric getInFalse() { return (BStatusNumeric)get(inFalse); }
  
  /**
   * Set the <code>inFalse</code> property.
   * @see com.tridium.kitControl.util.BNumericSwitch#inFalse
   */
  public void setInFalse(BStatusNumeric v) { set(inFalse,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericSwitch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue out, Context cx)
  {
    String invalidFacet = Lexicon.make(getType().getModule(), cx).getText("numericSwitch.invalidInSwitch");
    if(getInSwitch().getStatus().isValid())
    {
      if (getInSwitch().getValue())
      {
        workingValue.copyFrom(getInTrue());
        workingValue.setStatus(propagate(getInTrue().getStatus()));
      }
      else
      {
        workingValue.copyFrom(getInFalse());
        workingValue.setStatus(propagate(getInFalse().getStatus()));
      }
      BStatus s = workingValue.getStatus();
      workingValue.setStatus(BStatus.make(s.getBits(), BFacets.makeRemove(s.getFacets(), invalidFacet)));
    }
    else
    {
      workingValue.copyFrom(getOut());
      workingValue.setStatus( BStatus.make (workingValue.getStatus(), invalidFacet, true) );
    }
    out.copyFrom(workingValue);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");

  BStatusNumeric workingValue = new BStatusNumeric();

}
