/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BNumericSelect uses a numeric to switch between multiple numerics.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BNumericSelect
  extends BMuxSwitch
  implements BIStatus, BINumeric
{  

  public static final Property facets = newProperty(0, BFacets.makeNumeric());

  /*-
  
  class BNumericSelect
  {
    properties
    {
      out: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      inA: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inB: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inC: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inD: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inE: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inF: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inG: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inH: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inI: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inJ: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BNumericSelect(299243469)1.0$ @*/
/* Generated Wed Aug 11 09:31:17 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BNumericSelect#getOut
   * @see com.tridium.kitControl.util.BNumericSelect#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInA
   * @see com.tridium.kitControl.util.BNumericSelect#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inA
   */
  public BStatusNumeric getInA() { return (BStatusNumeric)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inA
   */
  public void setInA(BStatusNumeric v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInB
   * @see com.tridium.kitControl.util.BNumericSelect#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inB
   */
  public BStatusNumeric getInB() { return (BStatusNumeric)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inB
   */
  public void setInB(BStatusNumeric v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInC
   * @see com.tridium.kitControl.util.BNumericSelect#setInC
   */
  public static final Property inC = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inC
   */
  public BStatusNumeric getInC() { return (BStatusNumeric)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inC
   */
  public void setInC(BStatusNumeric v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInD
   * @see com.tridium.kitControl.util.BNumericSelect#setInD
   */
  public static final Property inD = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inD
   */
  public BStatusNumeric getInD() { return (BStatusNumeric)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inD
   */
  public void setInD(BStatusNumeric v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Property "inE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInE
   * @see com.tridium.kitControl.util.BNumericSelect#setInE
   */
  public static final Property inE = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inE
   */
  public BStatusNumeric getInE() { return (BStatusNumeric)get(inE); }
  
  /**
   * Set the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inE
   */
  public void setInE(BStatusNumeric v) { set(inE,v,null); }

////////////////////////////////////////////////////////////////
// Property "inF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInF
   * @see com.tridium.kitControl.util.BNumericSelect#setInF
   */
  public static final Property inF = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inF
   */
  public BStatusNumeric getInF() { return (BStatusNumeric)get(inF); }
  
  /**
   * Set the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inF
   */
  public void setInF(BStatusNumeric v) { set(inF,v,null); }

////////////////////////////////////////////////////////////////
// Property "inG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInG
   * @see com.tridium.kitControl.util.BNumericSelect#setInG
   */
  public static final Property inG = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inG
   */
  public BStatusNumeric getInG() { return (BStatusNumeric)get(inG); }
  
  /**
   * Set the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inG
   */
  public void setInG(BStatusNumeric v) { set(inG,v,null); }

////////////////////////////////////////////////////////////////
// Property "inH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInH
   * @see com.tridium.kitControl.util.BNumericSelect#setInH
   */
  public static final Property inH = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inH
   */
  public BStatusNumeric getInH() { return (BStatusNumeric)get(inH); }
  
  /**
   * Set the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inH
   */
  public void setInH(BStatusNumeric v) { set(inH,v,null); }

////////////////////////////////////////////////////////////////
// Property "inI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInI
   * @see com.tridium.kitControl.util.BNumericSelect#setInI
   */
  public static final Property inI = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inI
   */
  public BStatusNumeric getInI() { return (BStatusNumeric)get(inI); }
  
  /**
   * Set the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inI
   */
  public void setInI(BStatusNumeric v) { set(inI,v,null); }

////////////////////////////////////////////////////////////////
// Property "inJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#getInJ
   * @see com.tridium.kitControl.util.BNumericSelect#setInJ
   */
  public static final Property inJ = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inJ
   */
  public BStatusNumeric getInJ() { return (BStatusNumeric)get(inJ); }
  
  /**
   * Set the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BNumericSelect#inJ
   */
  public void setInJ(BStatusNumeric v) { set(inJ,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericSelect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Get the control output value.
   */
  public BStatusValue getNullInstance()
  {
    return new BStatusNumeric();
  }

  public final BStatusValue getInStatusValue(int select)
  {
    switch(select)
    {
    case 1: return getInA();
    case 2: return getInB();
    case 3: return getInC();
    case 4: return getInD();
    case 5: return getInE();
    case 6: return getInF();
    case 7: return getInG();
    case 8: return getInH();
    case 9: return getInI();
    case 10: return getInJ();
    }
    return getNullInstance();
  }
  
  public void setOutput(BStatusValue value)
  {
    setOut((BStatusNumeric)value );
  }
  
  public BStatus getOutStatus()
  {
    return getOut().getStatus();
  }
  
  public void setOutStatus(BStatus status)
  {
    getOut().setStatus(status);
  }
  
  
public String toString(Context cx) { return getOut().toString(cx); }
////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getOut().getStatus().getFacets(); }


  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");


}
