/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BMinMaxAvg uses a numeric to switch between multiple numerics.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BMinMaxAvg
  extends BDecaInputNumeric
{  

  public static final Property facets = newProperty(0, BFacets.makeNumeric());

  /*-
  
  class BMinMaxAvg
  {
    properties
    {
    
      min: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      max: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      avg: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BMinMaxAvg(2167679368)1.0$ @*/
/* Generated Tue Apr 20 14:27:24 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BMinMaxAvg#getMin
   * @see com.tridium.kitControl.util.BMinMaxAvg#setMin
   */
  public static final Property min = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>min</code> property.
   * @see com.tridium.kitControl.util.BMinMaxAvg#min
   */
  public BStatusNumeric getMin() { return (BStatusNumeric)get(min); }
  
  /**
   * Set the <code>min</code> property.
   * @see com.tridium.kitControl.util.BMinMaxAvg#min
   */
  public void setMin(BStatusNumeric v) { set(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BMinMaxAvg#getMax
   * @see com.tridium.kitControl.util.BMinMaxAvg#setMax
   */
  public static final Property max = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>max</code> property.
   * @see com.tridium.kitControl.util.BMinMaxAvg#max
   */
  public BStatusNumeric getMax() { return (BStatusNumeric)get(max); }
  
  /**
   * Set the <code>max</code> property.
   * @see com.tridium.kitControl.util.BMinMaxAvg#max
   */
  public void setMax(BStatusNumeric v) { set(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "avg"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>avg</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BMinMaxAvg#getAvg
   * @see com.tridium.kitControl.util.BMinMaxAvg#setAvg
   */
  public static final Property avg = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>avg</code> property.
   * @see com.tridium.kitControl.util.BMinMaxAvg#avg
   */
  public BStatusNumeric getAvg() { return (BStatusNumeric)get(avg); }
  
  /**
   * Set the <code>avg</code> property.
   * @see com.tridium.kitControl.util.BMinMaxAvg#avg
   */
  public void setAvg(BStatusNumeric v) { set(avg,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMinMaxAvg.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  public BFacets getSlotFacets(Slot slot)
  {
    if(slot.isProperty())
    {
      if( slot.asProperty().equals(min) ||
          slot.asProperty().equals(max) ||
          slot.asProperty().equals(avg)   )
        return getFacets();
    }
    return super.getSlotFacets(slot);
  }


  public void doCalculate()
  {
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;
    double avg = 0.0;
    double avgCount = 0;
    for(int i = 0; i < getNumberValues(); i++)
    {
      BStatusNumeric value = getInStatusValue(i);
      if(value.getStatus().isValid() && !(Double.isNaN(value.getValue())))
      {
        if(value.getValue() < min) min = value.getValue();
        if(value.getValue() > max) max = value.getValue();
        avg = avg + value.getValue();
        avgCount++;
      }
    }
    if(min == Double.POSITIVE_INFINITY) min = Double.NaN;
    if(max == Double.NEGATIVE_INFINITY) min = Double.NaN;
    avg = avg / avgCount;
    getMin().setValue(min);
    getMax().setValue(max);
    getAvg().setValue(avg);
  }

  public final BStatusNumeric getInStatusValue(int select)
  {
    switch(select)
    {
    case 0: return getInA();
    case 1: return getInB();
    case 2: return getInC();
    case 3: return getInD();
    case 4: return getInE();
    case 5: return getInF();
    case 6: return getInG();
    case 7: return getInH();
    case 8: return getInI();
    case 9: return getInJ();
    }
    return new BStatusNumeric();
  }
  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");


}
