/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BLatch is the base class for latches. 
 * with only an output element.
 *
 * @author    Andy Saunders
  * @creation  16 April 04
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public abstract class BLatch
  extends BComponent
{ 

  /*-
  
  class BLatch
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against all out properties.
        default {[ BFacets.DEFAULT ]}
        
      clock: BStatusBoolean
        -- This intput is used to latch the input property into the output property
        -- on the rising edge.
        flags { operator, transient, summary }
        default {[ new BStatusBoolean() ]}
        
    }

    actions
    {
      latch()
      
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BLatch(382034152)1.0$ @*/
/* Generated Mon May 31 10:07:57 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against all out properties.
   * @see com.tridium.kitControl.util.BLatch#getFacets
   * @see com.tridium.kitControl.util.BLatch#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.DEFAULT,null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.util.BLatch#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.util.BLatch#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "clock"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clock</code> property.
   * This intput is used to latch the input property into
   * the output property on the rising edge.
   * @see com.tridium.kitControl.util.BLatch#getClock
   * @see com.tridium.kitControl.util.BLatch#setClock
   */
  public static final Property clock = newProperty(Flags.OPERATOR|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>clock</code> property.
   * @see com.tridium.kitControl.util.BLatch#clock
   */
  public BStatusBoolean getClock() { return (BStatusBoolean)get(clock); }
  
  /**
   * Set the <code>clock</code> property.
   * @see com.tridium.kitControl.util.BLatch#clock
   */
  public void setClock(BStatusBoolean v) { set(clock,v,null); }

////////////////////////////////////////////////////////////////
// Action "latch"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>latch</code> action.
   * @see com.tridium.kitControl.util.BLatch#latch()
   */
  public static final Action latch = newAction(0,null);
  
  /**
   * Invoke the <code>latch</code> action.
   * @see com.tridium.kitControl.util.BLatch#latch
   */
  public void latch() { invoke(latch,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLatch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  public void started()
  {
  }

  public void changed(Property property, Context context) 
  {
    if(isRunning())
    {
      if(property == clock)
      {
        currentClock = getClock().getValue();
        if(getClock().getStatus().isValid())
        {
          if(currentClock && !lastClock)
          {
            setOutStatusValue(getInStatusValue());
          }
          lastClock = currentClock;
        }
      }
    }
  }


  public void doLatch()
  {
    setOutStatusValue(getInStatusValue());
  }

  public abstract void setOutStatusValue(BStatusValue value);
  public abstract BStatusValue getInStatusValue();


  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().startsWith("out")) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/numericPoint.png");

  private boolean currentClock;
  private boolean lastClock;
}
