/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.util.*;

import com.tridium.kitControl.*;

/**
 * BEnumSwitch uses a boolean to switch between two StatusEnums.
 *
 * @author    Andy Saunders
 * @creation  4 Sept 01
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BEnumSwitch
  extends BKitEnumPoint
{  

  /*-
  
  class BEnumSwitch
  {
    properties
    {
      inSwitch: BStatusBoolean
        -- Value to control which input to output.
        flags { summary }
        default {[ new BStatusBoolean(false) ]}
      inTrue: BStatusEnum
        -- Value to output when in inSwitch is true.
        flags { summary }
        default {[ new BStatusEnum() ]}
      inFalse: BStatusEnum
        -- Value to output when in inSwitch is false.
        flags { summary }
        default {[ new BStatusEnum() ]}
        
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BEnumSwitch(373597412)1.0$ @*/
/* Generated Thu May 05 07:10:47 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inSwitch"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inSwitch</code> property.
   * Value to control which input to output.
   * @see com.tridium.kitControl.util.BEnumSwitch#getInSwitch
   * @see com.tridium.kitControl.util.BEnumSwitch#setInSwitch
   */
  public static final Property inSwitch = newProperty(Flags.SUMMARY, new BStatusBoolean(false),null);
  
  /**
   * Get the <code>inSwitch</code> property.
   * @see com.tridium.kitControl.util.BEnumSwitch#inSwitch
   */
  public BStatusBoolean getInSwitch() { return (BStatusBoolean)get(inSwitch); }
  
  /**
   * Set the <code>inSwitch</code> property.
   * @see com.tridium.kitControl.util.BEnumSwitch#inSwitch
   */
  public void setInSwitch(BStatusBoolean v) { set(inSwitch,v,null); }

////////////////////////////////////////////////////////////////
// Property "inTrue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inTrue</code> property.
   * Value to output when in inSwitch is true.
   * @see com.tridium.kitControl.util.BEnumSwitch#getInTrue
   * @see com.tridium.kitControl.util.BEnumSwitch#setInTrue
   */
  public static final Property inTrue = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inTrue</code> property.
   * @see com.tridium.kitControl.util.BEnumSwitch#inTrue
   */
  public BStatusEnum getInTrue() { return (BStatusEnum)get(inTrue); }
  
  /**
   * Set the <code>inTrue</code> property.
   * @see com.tridium.kitControl.util.BEnumSwitch#inTrue
   */
  public void setInTrue(BStatusEnum v) { set(inTrue,v,null); }

////////////////////////////////////////////////////////////////
// Property "inFalse"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inFalse</code> property.
   * Value to output when in inSwitch is false.
   * @see com.tridium.kitControl.util.BEnumSwitch#getInFalse
   * @see com.tridium.kitControl.util.BEnumSwitch#setInFalse
   */
  public static final Property inFalse = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inFalse</code> property.
   * @see com.tridium.kitControl.util.BEnumSwitch#inFalse
   */
  public BStatusEnum getInFalse() { return (BStatusEnum)get(inFalse); }
  
  /**
   * Set the <code>inFalse</code> property.
   * @see com.tridium.kitControl.util.BEnumSwitch#inFalse
   */
  public void setInFalse(BStatusEnum v) { set(inFalse,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumSwitch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().startsWith("in")) return getFacets();
    return super.getSlotFacets(slot);
  }



  public void onExecute(BStatusValue out, Context cx)
  {
    String invalidFacet = Lexicon.make(getType().getModule(), cx).getText("numericSwitch.invalidInSwitch");
    if(getInSwitch().getStatus().isValid())
    {
      if (getInSwitch().getValue())
      {
        workingValue.copyFrom(getInTrue());
        workingValue.setStatus(propagate(getInTrue().getStatus()));
      }
      else
      {
        workingValue.copyFrom(getInFalse());
        workingValue.setStatus(propagate(getInFalse().getStatus()));
      }
      BStatus s = workingValue.getStatus();
      workingValue.setStatus(BStatus.make(s.getBits(), BFacets.makeRemove(s.getFacets(), invalidFacet)));
    }
    else
    {
      workingValue.copyFrom(getOut());
      workingValue.setStatus( BStatus.make (workingValue.getStatus(), invalidFacet, true) );
    }
    out.copyFrom(workingValue);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");

  BStatusEnum workingValue = new BStatusEnum();

}
