/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BEnumLatch is used to latch an enum value on the rising edge of the Clock property.
 *
 * @author    Andy Saunders
 * @creation  16 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BEnumLatch
  extends BLatch
  implements BIStatus, BIEnum
{  

  public static final Property facets = newProperty(0, BFacets.makeEnum());

  /*-
  
  class BEnumLatch
  {
    properties
    {
      out: BStatusEnum
        flags { operator, readonly, transient, summary }
        default {[ new BStatusEnum() ]}
        
      in: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BEnumLatch(3459553735)1.0$ @*/
/* Generated Fri Apr 16 16:44:52 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BEnumLatch#getOut
   * @see com.tridium.kitControl.util.BEnumLatch#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BEnumLatch#out
   */
  public BStatusEnum getOut() { return (BStatusEnum)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BEnumLatch#out
   */
  public void setOut(BStatusEnum v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.util.BEnumLatch#getIn
   * @see com.tridium.kitControl.util.BEnumLatch#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.util.BEnumLatch#in
   */
  public BStatusEnum getIn() { return (BStatusEnum)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.util.BEnumLatch#in
   */
  public void setIn(BStatusEnum v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumLatch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Get the control output value.
   */
  public final void setOutStatusValue(BStatusValue value) 
  { 
    setOut((BStatusEnum)value);
  }

  public final BStatusValue getInStatusValue() 
  { 
    return (BStatusValue)(getIn().newCopy());
  }

  public String toString(Context cx) { return getOut().toString(cx); }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/enumPoint.png");


}
