/*
 * Copyright 2007, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*; 
import javax.baja.status.*;
import javax.baja.log.*;

/**
 * Analogue to Digital Demultiplexor
 * 
 * @author    Gareth Johnson
 * @creation  30 Nov 2006
 * @version   $Revision: 1$ $Date: 01/29/2007 12:20 AM$
 * @since     Niagara 3.4
 */
public final class BDigitalInputDemux extends BComponent
{
/*-
  class BDigitalInputDemux
  {
    properties
    { 
      propagateFlags: BStatus
        -- defines which input status flags will be propagated from
        -- input to output.
        default{[ BStatus.ok ]}
      
      in: BStatusNumeric
        -- Analogue input
        flags{ transient, summary }
        default{[ new BStatusNumeric() ]}
        
      inOffset: double
        -- The offset for the input
        default{[ 0.00 ]}
     
      out1: BStatusBoolean
        -- Boolean output
        flags{ transient, readonly, summary }
        default{[ new BStatusBoolean() ]}
        
      out2: BStatusBoolean
        -- Boolean output
        flags{ transient, readonly, summary }
        default{[ new BStatusBoolean() ]}
            
      out3: BStatusBoolean
        -- Boolean output
        flags{ transient, readonly, summary }
        default{[ new BStatusBoolean() ]}
            
      out4: BStatusBoolean
        -- Boolean output
        flags{ transient, readonly, summary }
        default{[ new BStatusBoolean() ]}
      
      out1Value: double
        -- Analogue value
        default{[ 4.8 ]}
        
      out2Value: double
        -- Analogue value
        default{[ 2.4 ]}
        
      out3Value: double
       -- Analogue value
       default{[ 1.2 ]}
      
      out4Value: double
        -- Analogue value
        default{[ 0.6 ]}  
        
      deadBand: double
        -- The deadband
        default{[ 0.1 ]}
    }
    
    actions
    {
      execute()
        -- Execute the component
        flags{ async, hidden }
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControlEurope.BDigitalInputDemux(2483002096)1.0$ @*/
/* Generated Sat Feb 02 13:43:16 GMT 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getPropagateFlags
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.ok,null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * Analogue input
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getIn
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "inOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inOffset</code> property.
   * The offset for the input
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getInOffset
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setInOffset
   */
  public static final Property inOffset = newProperty(0, 0.00,null);
  
  /**
   * Get the <code>inOffset</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#inOffset
   */
  public double getInOffset() { return getDouble(inOffset); }
  
  /**
   * Set the <code>inOffset</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#inOffset
   */
  public void setInOffset(double v) { setDouble(inOffset,v,null); }

////////////////////////////////////////////////////////////////
// Property "out1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out1</code> property.
   * Boolean output
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut1
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut1
   */
  public static final Property out1 = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out1</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out1
   */
  public BStatusBoolean getOut1() { return (BStatusBoolean)get(out1); }
  
  /**
   * Set the <code>out1</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out1
   */
  public void setOut1(BStatusBoolean v) { set(out1,v,null); }

////////////////////////////////////////////////////////////////
// Property "out2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out2</code> property.
   * Boolean output
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut2
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut2
   */
  public static final Property out2 = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out2</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out2
   */
  public BStatusBoolean getOut2() { return (BStatusBoolean)get(out2); }
  
  /**
   * Set the <code>out2</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out2
   */
  public void setOut2(BStatusBoolean v) { set(out2,v,null); }

////////////////////////////////////////////////////////////////
// Property "out3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out3</code> property.
   * Boolean output
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut3
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut3
   */
  public static final Property out3 = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out3</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out3
   */
  public BStatusBoolean getOut3() { return (BStatusBoolean)get(out3); }
  
  /**
   * Set the <code>out3</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out3
   */
  public void setOut3(BStatusBoolean v) { set(out3,v,null); }

////////////////////////////////////////////////////////////////
// Property "out4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out4</code> property.
   * Boolean output
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut4
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut4
   */
  public static final Property out4 = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out4</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out4
   */
  public BStatusBoolean getOut4() { return (BStatusBoolean)get(out4); }
  
  /**
   * Set the <code>out4</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out4
   */
  public void setOut4(BStatusBoolean v) { set(out4,v,null); }

////////////////////////////////////////////////////////////////
// Property "out1Value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out1Value</code> property.
   * Analogue value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut1Value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut1Value
   */
  public static final Property out1Value = newProperty(0, 4.8,null);
  
  /**
   * Get the <code>out1Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out1Value
   */
  public double getOut1Value() { return getDouble(out1Value); }
  
  /**
   * Set the <code>out1Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out1Value
   */
  public void setOut1Value(double v) { setDouble(out1Value,v,null); }

////////////////////////////////////////////////////////////////
// Property "out2Value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out2Value</code> property.
   * Analogue value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut2Value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut2Value
   */
  public static final Property out2Value = newProperty(0, 2.4,null);
  
  /**
   * Get the <code>out2Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out2Value
   */
  public double getOut2Value() { return getDouble(out2Value); }
  
  /**
   * Set the <code>out2Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out2Value
   */
  public void setOut2Value(double v) { setDouble(out2Value,v,null); }

////////////////////////////////////////////////////////////////
// Property "out3Value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out3Value</code> property.
   * Analogue value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut3Value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut3Value
   */
  public static final Property out3Value = newProperty(0, 1.2,null);
  
  /**
   * Get the <code>out3Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out3Value
   */
  public double getOut3Value() { return getDouble(out3Value); }
  
  /**
   * Set the <code>out3Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out3Value
   */
  public void setOut3Value(double v) { setDouble(out3Value,v,null); }

////////////////////////////////////////////////////////////////
// Property "out4Value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out4Value</code> property.
   * Analogue value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getOut4Value
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setOut4Value
   */
  public static final Property out4Value = newProperty(0, 0.6,null);
  
  /**
   * Get the <code>out4Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out4Value
   */
  public double getOut4Value() { return getDouble(out4Value); }
  
  /**
   * Set the <code>out4Value</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#out4Value
   */
  public void setOut4Value(double v) { setDouble(out4Value,v,null); }

////////////////////////////////////////////////////////////////
// Property "deadBand"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deadBand</code> property.
   * The deadband
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#getDeadBand
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#setDeadBand
   */
  public static final Property deadBand = newProperty(0, 0.1,null);
  
  /**
   * Get the <code>deadBand</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#deadBand
   */
  public double getDeadBand() { return getDouble(deadBand); }
  
  /**
   * Set the <code>deadBand</code> property.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#deadBand
   */
  public void setDeadBand(double v) { setDouble(deadBand,v,null); }

////////////////////////////////////////////////////////////////
// Action "execute"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>execute</code> action.
   * Execute the component
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#execute()
   */
  public static final Action execute = newAction(Flags.ASYNC|Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>execute</code> action.
   * @see com.tridium.kitControlEurope.BDigitalInputDemux#execute
   */
  public void execute() { invoke(execute,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDigitalInputDemux.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  /**
   * Called when the component is started
   */
  public void started() throws Exception
  {
    execute();
  }
    
  /**
   * Called when one of the properties is changed
   */
  public void changed(Property prop, Context cx)
  {
    if (isRunning())
    {
      if (prop.equals(in) || prop.equals(deadBand) ||
          prop.equals(out1Value) || prop.equals(out2Value) ||
          prop.equals(out3Value) || prop.equals(out4Value) || prop.equals(inOffset)) 
      {
        execute();
      }
    }
  }
  
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("propagateFlags"))
    {
      return PROPAGATE_FACETS;
    }
    else return super.getSlotFacets(slot);
  }
  
  public BIcon getIcon()
  {
    return icon;
  }
  
////////////////////////////////////////////////////////////////
// Execution
////////////////////////////////////////////////////////////////
 
  public void doExecute() throws Exception
  {
    // Input value
    double inVal = getIn().getValue();  
    
    if (getIn().getStatus().isNull())
      inVal = 0.00;
    else
      inVal += getInOffset();
    
    // Get output values
    double a = getOut1Value(); 
    double b = getOut2Value();
    double c = getOut3Value();
    double d = getOut4Value();   
    
    // Flags
    boolean aOut = false;
    boolean bOut = false;
    boolean cOut = false;
    boolean dOut = false;   
    
    // Efficiency
    tempDeadBand = getDeadBand();
    
    if (tempDeadBand > 0.00)
      tempDeadBand /= 2;
      
    if (isEqual(inVal, a))
    {
      aOut = true;      
    }
    else if (isEqual(inVal, (a + b)))  
    {
      aOut = true;
      bOut = true;
    }
    else if (isEqual(inVal, (a + c)))  
    {
      aOut = true;
      cOut = true;
    }
    else if (isEqual(inVal, (a + d)))  
    {
      aOut = true;
      dOut = true;
    }
    else if (isEqual(inVal, (a + b + c)))  
    {
      aOut = true;
      bOut = true;
      cOut = true;
    }
    else if (isEqual(inVal, (a + b + d)))  
    {
      aOut = true;
      bOut = true;
      dOut = true;
    }
    else if (isEqual(inVal, (a + c + d)))  
    {
      aOut = true;
      cOut = true;
      dOut = true;
    }
    else if (isEqual(inVal, (a + b + c + d)))  
    {
      aOut = true;
      bOut = true;
      cOut = true;
      dOut = true;
    }
    else if (isEqual(inVal, b))  
    {
      bOut = true;
    }
    else if (isEqual(inVal, (b + c)))  
    {
      bOut = true;
      cOut = true;
    }
    else if (isEqual(inVal, (b + d)))  
    {
      bOut = true;
      dOut = true;
    }
    else if (isEqual(inVal, (b + c + d)))  
    {
      bOut = true;
      cOut = true;
      dOut = true;
    }
    else if (isEqual(inVal, c))  
    {
      cOut = true;
    }
    else if (isEqual(inVal, c + d))  
    {
      cOut = true; 
      dOut = true;
    }
    else if (isEqual(inVal, d))  
    {
      dOut = true;
    }
    else if (!isEqual(inVal, 0.00)) 
    {
      // Error 
      log.warning("Input value for digitalInputDemux: " + inVal);
    }
    
    getOut1().setValue(aOut);
    getOut2().setValue(bOut);
    getOut3().setValue(cOut);
    getOut4().setValue(dOut);
    
    // Propogate status
    BStatus newStatus = propagate(getIn().getStatus());
    
    getOut1().setStatus(newStatus);
    getOut2().setStatus(newStatus);
    getOut3().setStatus(newStatus);
    getOut4().setStatus(newStatus);
  }
  
  private boolean isEqual(double a, double b)
  {    
    double b1 = b + tempDeadBand;
    double b2 = b - tempDeadBand;
    
    return ((Math.abs(b1 - a) < 0.0001) || b1 > a) && ((Math.abs(b2 - a) < 0.0001) || b2 < a);
  } 
  
  /**
   * Create a new status by masking out only the standard
   * flags which should be propagated from inputs to outputs.
   * See PROPOGATE_MASK for the flags which are propagated.
   *
   * @return <code>make(s.getBits() & PROPOGATE_MASK)</code>
   */
  private BStatus propagate(BStatus s)
  {
    return BStatus.make(s.getBits() & getPropagateFlags().getBits());
  }
 
////////////////////////////////////////////////////////////////
// Fields
////////////////////////////////////////////////////////////////
  
  private double tempDeadBand = 0.00;
  private static final Log log = Log.getLog("kitControl.digitalInputDemux");
  
  private static final BIcon icon = BIcon.std("control/control.png");
  
  private static final BFacets PROPAGATE_FACETS = BFacets.make(BFacets.FIELD_EDITOR, BString.make("kitControl:PropagateFlagsFE"), BFacets.UX_FIELD_EDITOR, BString.make("kitControl:PropagateFlagsEditor"));
}