/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

import com.tridium.kitControl.*;
/**
 * BCounter is a component that count boolean input transitions.
 * <pre>
 *    Positive transitions on the countUp property will increment the out property.
 *    Positive transitions on the countDown property will decrement the out property.
 * </pre>
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BCounter
  extends BKitNumeric
  implements BIStatus, BINumeric
{

  /*-
  
  class BCounter
  {
    properties
    {
      
      out: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      countUp: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}

      countDown: BStatusBoolean
        default {[ new BStatusBoolean() ]}

      presetIn: BStatusBoolean
        default {[ new BStatusBoolean() ]}
        
      clearIn: BStatusBoolean
        default {[ new BStatusBoolean() ]}
        
      presetValue: BStatusNumeric
        default {[ new BStatusNumeric() ]}
        
      countIncrement: float
        default {[ 1.0f ]}
        

    }

    actions
    {
      preset()
       flags {async}
      
      clear()  
       flags {async}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BCounter(274118317)1.0$ @*/
/* Generated Mon Apr 09 13:01:15 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BCounter#getOut
   * @see com.tridium.kitControl.util.BCounter#setOut
   */
  public static final Property out = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BCounter#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BCounter#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "countUp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>countUp</code> property.
   * @see com.tridium.kitControl.util.BCounter#getCountUp
   * @see com.tridium.kitControl.util.BCounter#setCountUp
   */
  public static final Property countUp = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>countUp</code> property.
   * @see com.tridium.kitControl.util.BCounter#countUp
   */
  public BStatusBoolean getCountUp() { return (BStatusBoolean)get(countUp); }
  
  /**
   * Set the <code>countUp</code> property.
   * @see com.tridium.kitControl.util.BCounter#countUp
   */
  public void setCountUp(BStatusBoolean v) { set(countUp,v,null); }

////////////////////////////////////////////////////////////////
// Property "countDown"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>countDown</code> property.
   * @see com.tridium.kitControl.util.BCounter#getCountDown
   * @see com.tridium.kitControl.util.BCounter#setCountDown
   */
  public static final Property countDown = newProperty(0, new BStatusBoolean(),null);
  
  /**
   * Get the <code>countDown</code> property.
   * @see com.tridium.kitControl.util.BCounter#countDown
   */
  public BStatusBoolean getCountDown() { return (BStatusBoolean)get(countDown); }
  
  /**
   * Set the <code>countDown</code> property.
   * @see com.tridium.kitControl.util.BCounter#countDown
   */
  public void setCountDown(BStatusBoolean v) { set(countDown,v,null); }

////////////////////////////////////////////////////////////////
// Property "presetIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>presetIn</code> property.
   * @see com.tridium.kitControl.util.BCounter#getPresetIn
   * @see com.tridium.kitControl.util.BCounter#setPresetIn
   */
  public static final Property presetIn = newProperty(0, new BStatusBoolean(),null);
  
  /**
   * Get the <code>presetIn</code> property.
   * @see com.tridium.kitControl.util.BCounter#presetIn
   */
  public BStatusBoolean getPresetIn() { return (BStatusBoolean)get(presetIn); }
  
  /**
   * Set the <code>presetIn</code> property.
   * @see com.tridium.kitControl.util.BCounter#presetIn
   */
  public void setPresetIn(BStatusBoolean v) { set(presetIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "clearIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clearIn</code> property.
   * @see com.tridium.kitControl.util.BCounter#getClearIn
   * @see com.tridium.kitControl.util.BCounter#setClearIn
   */
  public static final Property clearIn = newProperty(0, new BStatusBoolean(),null);
  
  /**
   * Get the <code>clearIn</code> property.
   * @see com.tridium.kitControl.util.BCounter#clearIn
   */
  public BStatusBoolean getClearIn() { return (BStatusBoolean)get(clearIn); }
  
  /**
   * Set the <code>clearIn</code> property.
   * @see com.tridium.kitControl.util.BCounter#clearIn
   */
  public void setClearIn(BStatusBoolean v) { set(clearIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "presetValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>presetValue</code> property.
   * @see com.tridium.kitControl.util.BCounter#getPresetValue
   * @see com.tridium.kitControl.util.BCounter#setPresetValue
   */
  public static final Property presetValue = newProperty(0, new BStatusNumeric(),null);
  
  /**
   * Get the <code>presetValue</code> property.
   * @see com.tridium.kitControl.util.BCounter#presetValue
   */
  public BStatusNumeric getPresetValue() { return (BStatusNumeric)get(presetValue); }
  
  /**
   * Set the <code>presetValue</code> property.
   * @see com.tridium.kitControl.util.BCounter#presetValue
   */
  public void setPresetValue(BStatusNumeric v) { set(presetValue,v,null); }

////////////////////////////////////////////////////////////////
// Property "countIncrement"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>countIncrement</code> property.
   * @see com.tridium.kitControl.util.BCounter#getCountIncrement
   * @see com.tridium.kitControl.util.BCounter#setCountIncrement
   */
  public static final Property countIncrement = newProperty(0, 1.0f,null);
  
  /**
   * Get the <code>countIncrement</code> property.
   * @see com.tridium.kitControl.util.BCounter#countIncrement
   */
  public float getCountIncrement() { return getFloat(countIncrement); }
  
  /**
   * Set the <code>countIncrement</code> property.
   * @see com.tridium.kitControl.util.BCounter#countIncrement
   */
  public void setCountIncrement(float v) { setFloat(countIncrement,v,null); }

////////////////////////////////////////////////////////////////
// Action "preset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>preset</code> action.
   * @see com.tridium.kitControl.util.BCounter#preset()
   */
  public static final Action preset = newAction(Flags.ASYNC,null);
  
  /**
   * Invoke the <code>preset</code> action.
   * @see com.tridium.kitControl.util.BCounter#preset
   */
  public void preset() { invoke(preset,null,null); }

////////////////////////////////////////////////////////////////
// Action "clear"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clear</code> action.
   * @see com.tridium.kitControl.util.BCounter#clear()
   */
  public static final Action clear = newAction(Flags.ASYNC,null);
  
  /**
   * Invoke the <code>clear</code> action.
   * @see com.tridium.kitControl.util.BCounter#clear
   */
  public void clear() { invoke(clear,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCounter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BCounter()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    //getOut().setValue( calculate() );
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == countUp || p == countDown || p == presetIn || p == clearIn)
    {
      getOut().setValue( calculate() );
      getOut().setStatus( propagateStatus() );
    }
  }

  public BStatus propagateStatus()
  {
    int status   = getCountUp().getStatus().getBits();
    status       = status | getCountDown().getStatus().getBits();
    status       = status | getPresetIn().getStatus().getBits();
    status       = status | getClearIn().getStatus().getBits();
    status       = status & getPropagateFlags().getBits();
    return BStatus.make(status);
  }

  public double calculate()
  {
    boolean countUp;
    boolean countDown;
    boolean preset;
    boolean clear;
    if(getCountUp().getStatus().isValid())
      countUp = getCountUp().getValue();
    else
      countUp = lastCountUp;
    if(getCountDown().getStatus().isValid())
      countDown = getCountDown().getValue();
    else
      countDown = lastCountDown;
    if(getPresetIn().getStatus().isValid())
      preset = getPresetIn().getValue();
    else
      preset = lastPreset;
    if(getClearIn().getStatus().isValid())
      clear = getClearIn().getValue();
    else
      clear = lastClear;

    double count = getOut().getValue();

    if(clear && !lastClear)
      count = 0f;
    if(preset && !lastPreset)
      count = getPresetValue().getValue();
    if(countUp && !lastCountUp)
      count = count + getCountIncrement() ;
    if(countDown && !lastCountDown)
      count = count - getCountIncrement() ;
    lastCountUp = countUp;
    lastCountDown = countDown;
    lastPreset = preset;
    lastClear = clear;
    return count;
  }

  public void doPreset()
  {
    getOut().setValue( getPresetValue().getValue() );
  }

  public void doClear()
  {
    getOut().setValue( 0f );
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }


  public BFacets getSlotFacets(Slot slot)
  {
    if ( slot.getName().equals("out") ) 
    {
      return getFacets();
    }
    else return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getOut().getStatus().getFacets(); }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  boolean lastCountUp;
  boolean lastCountDown;
  boolean lastPreset;
  boolean lastClear;
  
}
