/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.status.*;
import javax.baja.sys.*;
import javax.baja.util.Lexicon;

import com.tridium.kitControl.BKitBooleanPoint;

/**
 * BBooleanSwitch uses a boolean to switch between two booleans.
 *
 * @author    Lee Adcock
 * @creation  18 June 09
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BBooleanSwitch
  extends BKitBooleanPoint
{  

  /*-
  
  class BBooleanSwitch
  {
    properties
    {
      inSwitch: BStatusBoolean
        -- Value to control which input to output.
        flags { summary }
        default {[ new BStatusBoolean(false) ]}
      inTrue: BStatusBoolean
        -- Value to output when in inSwitch is true.
        flags { summary }
        default {[ new BStatusBoolean() ]}
      inFalse: BStatusBoolean
        -- Value to output when in inSwitch is false.
        flags { summary }
        default {[ new BStatusBoolean() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BBooleanSwitch(2530258578)1.0$ @*/
/* Generated Thu Jun 18 09:26:48 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inSwitch"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inSwitch</code> property.
   * Value to control which input to output.
   * @see com.tridium.kitControl.util.BBooleanSwitch#getInSwitch
   * @see com.tridium.kitControl.util.BBooleanSwitch#setInSwitch
   */
  public static final Property inSwitch = newProperty(Flags.SUMMARY, new BStatusBoolean(false),null);
  
  /**
   * Get the <code>inSwitch</code> property.
   * @see com.tridium.kitControl.util.BBooleanSwitch#inSwitch
   */
  public BStatusBoolean getInSwitch() { return (BStatusBoolean)get(inSwitch); }
  
  /**
   * Set the <code>inSwitch</code> property.
   * @see com.tridium.kitControl.util.BBooleanSwitch#inSwitch
   */
  public void setInSwitch(BStatusBoolean v) { set(inSwitch,v,null); }

////////////////////////////////////////////////////////////////
// Property "inTrue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inTrue</code> property.
   * Value to output when in inSwitch is true.
   * @see com.tridium.kitControl.util.BBooleanSwitch#getInTrue
   * @see com.tridium.kitControl.util.BBooleanSwitch#setInTrue
   */
  public static final Property inTrue = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inTrue</code> property.
   * @see com.tridium.kitControl.util.BBooleanSwitch#inTrue
   */
  public BStatusBoolean getInTrue() { return (BStatusBoolean)get(inTrue); }
  
  /**
   * Set the <code>inTrue</code> property.
   * @see com.tridium.kitControl.util.BBooleanSwitch#inTrue
   */
  public void setInTrue(BStatusBoolean v) { set(inTrue,v,null); }

////////////////////////////////////////////////////////////////
// Property "inFalse"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inFalse</code> property.
   * Value to output when in inSwitch is false.
   * @see com.tridium.kitControl.util.BBooleanSwitch#getInFalse
   * @see com.tridium.kitControl.util.BBooleanSwitch#setInFalse
   */
  public static final Property inFalse = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inFalse</code> property.
   * @see com.tridium.kitControl.util.BBooleanSwitch#inFalse
   */
  public BStatusBoolean getInFalse() { return (BStatusBoolean)get(inFalse); }
  
  /**
   * Set the <code>inFalse</code> property.
   * @see com.tridium.kitControl.util.BBooleanSwitch#inFalse
   */
  public void setInFalse(BStatusBoolean v) { set(inFalse,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanSwitch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue out, Context cx)
  {
    String invalidFacet = Lexicon.make(getType().getModule(), cx).getText("booleanSwitch.invalidInSwitch");
    if(getInSwitch().getStatus().isValid())
    {
      if (getInSwitch().getValue())
      {
        workingValue.copyFrom(getInTrue());
        workingValue.setStatus(propagate(getInTrue().getStatus()));
      }
      else
      {
        workingValue.copyFrom(getInFalse());
        workingValue.setStatus(propagate(getInFalse().getStatus()));
      }
      BStatus s = workingValue.getStatus();
      workingValue.setStatus(BStatus.make(s.getBits(), BFacets.makeRemove(s.getFacets(), invalidFacet)));
    }
    else
    {
      workingValue.copyFrom(getOut());
      workingValue.setStatus( BStatus.make (workingValue.getStatus(), invalidFacet, true) );
    }
    out.copyFrom(workingValue);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");

  BStatusBoolean workingValue = new BStatusBoolean();

}
