/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.timer;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;

/**
 * BTimeDifference will calculate the difference between two BAbsTime inputs in milliseconds.
 *    out = in1 - in2
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BTimeDifference
  extends BComponent
  implements BIStatus, BINumeric
{
  /*-
  
  class BTimeDifference
  {
    properties
    {
      out: BStatusNumeric
        flags { transient, readonly, summary }
        default {[ new BStatusNumeric(0.0) ]}
			  slotfacets {[ BFacets.makeNumeric(UnitDatabase.getUnit("millisecond"), 0) ]}

      in1: BAbsTime
        flags { summary }
        default {[ BAbsTime.NULL ]}
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, true) ]}
      
      in2: BAbsTime
        flags { summary }
        default {[ BAbsTime.NULL ]}
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, true) ]}
        
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.timer.BTimeDifference(1414735653)1.0$ @*/
/* Generated Tue Nov 23 14:33:49 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#getOut
   * @see com.tridium.kitControl.timer.BTimeDifference#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(0.0),BFacets.makeNumeric(UnitDatabase.getUnit("millisecond"), 0) );
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in1</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#getIn1
   * @see com.tridium.kitControl.timer.BTimeDifference#setIn1
   */
  public static final Property in1 = newProperty(Flags.SUMMARY, BAbsTime.NULL,BFacets.make(BFacets.SHOW_MILLISECONDS, true) );
  
  /**
   * Get the <code>in1</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#in1
   */
  public BAbsTime getIn1() { return (BAbsTime)get(in1); }
  
  /**
   * Set the <code>in1</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#in1
   */
  public void setIn1(BAbsTime v) { set(in1,v,null); }

////////////////////////////////////////////////////////////////
// Property "in2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in2</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#getIn2
   * @see com.tridium.kitControl.timer.BTimeDifference#setIn2
   */
  public static final Property in2 = newProperty(Flags.SUMMARY, BAbsTime.NULL,BFacets.make(BFacets.SHOW_MILLISECONDS, true) );
  
  /**
   * Get the <code>in2</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#in2
   */
  public BAbsTime getIn2() { return (BAbsTime)get(in2); }
  
  /**
   * Set the <code>in2</code> property.
   * @see com.tridium.kitControl.timer.BTimeDifference#in2
   */
  public void setIn2(BAbsTime v) { set(in2,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTimeDifference.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BTimeDifference()
  {
  }
  

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    double outValue = Double.NaN;
    if ( p.equals(in1) || p.equals(in2) )
    {
      if( !getIn1().isNull()  && !getIn2().isNull() )
        outValue = (double)(getIn1().getMillis() - getIn2().getMillis());
      getOut().setValue(outValue);
    }
    else
    {
      super.changed(p, cx);
    }
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getOut().getStatus().getFacets(); }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/trigger.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
