/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.timer;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BCurrentTime is a component exposes the current time as a BAbsTime.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BCurrentTime
  extends BComponent
{
  /*-
  
  class BCurrentTime
  {
    properties
    {
      facets: BFacets
        default {[ BFacets.make(BFacets.SHOW_DATE, BBoolean.make(true), BFacets.SHOW_TIME, BBoolean.make(true), BFacets.SHOW_SECONDS, BBoolean.make(true)) ]}
        
      updateTime: BRelTime
        default {[ BRelTime.make(500l) ]}
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, true) ]}
      
      out: BAbsTime
        flags { transient, readonly, summary }
        default {[ BAbsTime.make() ]}

    }

    actions
    {
      timerExpired()
        flags { hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.timer.BCurrentTime(3164422133)1.0$ @*/
/* Generated Tue Nov 23 13:27:41 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#getFacets
   * @see com.tridium.kitControl.timer.BCurrentTime#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.make(BFacets.SHOW_DATE, BBoolean.make(true), BFacets.SHOW_TIME, BBoolean.make(true), BFacets.SHOW_SECONDS, BBoolean.make(true)),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "updateTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>updateTime</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#getUpdateTime
   * @see com.tridium.kitControl.timer.BCurrentTime#setUpdateTime
   */
  public static final Property updateTime = newProperty(0, BRelTime.make(500l),BFacets.make(BFacets.SHOW_MILLISECONDS, true) );
  
  /**
   * Get the <code>updateTime</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#updateTime
   */
  public BRelTime getUpdateTime() { return (BRelTime)get(updateTime); }
  
  /**
   * Set the <code>updateTime</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#updateTime
   */
  public void setUpdateTime(BRelTime v) { set(updateTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#getOut
   * @see com.tridium.kitControl.timer.BCurrentTime#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, BAbsTime.make(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#out
   */
  public BAbsTime getOut() { return (BAbsTime)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BCurrentTime#out
   */
  public void setOut(BAbsTime v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "timerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timerExpired</code> action.
   * @see com.tridium.kitControl.timer.BCurrentTime#timerExpired()
   */
  public static final Action timerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>timerExpired</code> action.
   * @see com.tridium.kitControl.timer.BCurrentTime#timerExpired
   */
  public void timerExpired() { invoke(timerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCurrentTime.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BCurrentTime()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    initTimer();
  }

  protected void initTimer()
  {
    if (ticket != null) ticket.cancel();
    ticket = Clock.schedulePeriodically(this, getUpdateTime(), timerExpired, null);
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p.equals(updateTime))
    {
      initTimer();
    }
    else
    {
      super.changed(p, cx);
    }
  }

  public void doTimerExpired()
  {
    setOut(BAbsTime.now());
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
  */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/trigger.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  boolean lastInput;
  Clock.Ticket ticket;      // Used to manage the current timer
  
}
