/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.timer;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BBooleanDelay is a component that provices delayOn and delayOff timing.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BBooleanDelay
  extends BComponent
  implements BIStatus, BIBoolean
{
  /*-
  
  class BBooleanDelay
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
        
      in: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}

      onDelay: BRelTime
        slotfacets {[ BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0)) ]}
        default {[ BRelTime.make(1000l) ]}
      
      offDelay: BRelTime
        slotfacets {[ BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0)) ]}
        default {[ BRelTime.make(1000l) ]}
        
      onDelayActive: boolean
        flags { transient, readonly }
        default {[ false ]}
      
      offDelayActive: boolean
        flags { transient, readonly }
        default {[ false ]}
      
      out: BStatusBoolean
        flags { transient, summary, defaultOnClone }
        default {[ new BStatusBoolean(false) ]}

      outNot: BStatusBoolean
        flags { transient, summary, defaultOnClone }
        default {[ new BStatusBoolean(true) ]}

    }

    actions
    {
      onTimerExpired()
        flags { hidden }
        
      offTimerExpired()
        flags { hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.timer.BBooleanDelay(1331987474)1.0$ @*/
/* Generated Tue Feb 10 09:46:16 EST 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getFacets
   * @see com.tridium.kitControl.timer.BBooleanDelay#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getIn
   * @see com.tridium.kitControl.timer.BBooleanDelay#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "onDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDelay</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getOnDelay
   * @see com.tridium.kitControl.timer.BBooleanDelay#setOnDelay
   */
  public static final Property onDelay = newProperty(0, BRelTime.make(1000l),BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0)));
  
  /**
   * Get the <code>onDelay</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#onDelay
   */
  public BRelTime getOnDelay() { return (BRelTime)get(onDelay); }
  
  /**
   * Set the <code>onDelay</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#onDelay
   */
  public void setOnDelay(BRelTime v) { set(onDelay,v,null); }

////////////////////////////////////////////////////////////////
// Property "offDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offDelay</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getOffDelay
   * @see com.tridium.kitControl.timer.BBooleanDelay#setOffDelay
   */
  public static final Property offDelay = newProperty(0, BRelTime.make(1000l),BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0)));
  
  /**
   * Get the <code>offDelay</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#offDelay
   */
  public BRelTime getOffDelay() { return (BRelTime)get(offDelay); }
  
  /**
   * Set the <code>offDelay</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#offDelay
   */
  public void setOffDelay(BRelTime v) { set(offDelay,v,null); }

////////////////////////////////////////////////////////////////
// Property "onDelayActive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDelayActive</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getOnDelayActive
   * @see com.tridium.kitControl.timer.BBooleanDelay#setOnDelayActive
   */
  public static final Property onDelayActive = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>onDelayActive</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#onDelayActive
   */
  public boolean getOnDelayActive() { return getBoolean(onDelayActive); }
  
  /**
   * Set the <code>onDelayActive</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#onDelayActive
   */
  public void setOnDelayActive(boolean v) { setBoolean(onDelayActive,v,null); }

////////////////////////////////////////////////////////////////
// Property "offDelayActive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offDelayActive</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getOffDelayActive
   * @see com.tridium.kitControl.timer.BBooleanDelay#setOffDelayActive
   */
  public static final Property offDelayActive = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>offDelayActive</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#offDelayActive
   */
  public boolean getOffDelayActive() { return getBoolean(offDelayActive); }
  
  /**
   * Set the <code>offDelayActive</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#offDelayActive
   */
  public void setOffDelayActive(boolean v) { setBoolean(offDelayActive,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getOut
   * @see com.tridium.kitControl.timer.BBooleanDelay#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY|Flags.DEFAULT_ON_CLONE, new BStatusBoolean(false),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "outNot"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outNot</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#getOutNot
   * @see com.tridium.kitControl.timer.BBooleanDelay#setOutNot
   */
  public static final Property outNot = newProperty(Flags.TRANSIENT|Flags.SUMMARY|Flags.DEFAULT_ON_CLONE, new BStatusBoolean(true),null);
  
  /**
   * Get the <code>outNot</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#outNot
   */
  public BStatusBoolean getOutNot() { return (BStatusBoolean)get(outNot); }
  
  /**
   * Set the <code>outNot</code> property.
   * @see com.tridium.kitControl.timer.BBooleanDelay#outNot
   */
  public void setOutNot(BStatusBoolean v) { set(outNot,v,null); }

////////////////////////////////////////////////////////////////
// Action "onTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onTimerExpired</code> action.
   * @see com.tridium.kitControl.timer.BBooleanDelay#onTimerExpired()
   */
  public static final Action onTimerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>onTimerExpired</code> action.
   * @see com.tridium.kitControl.timer.BBooleanDelay#onTimerExpired
   */
  public void onTimerExpired() { invoke(onTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Action "offTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offTimerExpired</code> action.
   * @see com.tridium.kitControl.timer.BBooleanDelay#offTimerExpired()
   */
  public static final Action offTimerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>offTimerExpired</code> action.
   * @see com.tridium.kitControl.timer.BBooleanDelay#offTimerExpired
   */
  public void offTimerExpired() { invoke(offTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanDelay.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBooleanDelay()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    //getOut().setValue(getIn().getBoolean());
  }

  public void atSteadyState()
  {
      calculate();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;
    if (p == in)
      calculate();
  }

  public void calculate()
  {
    if(!getIn().getStatus().isValid())
      return;
    boolean input = getIn().getValue();
    if(input && !lastInput)
    {
      lastInput = input;
      if(getOnDelay().getMillis() == 0l)
      {
        if( offTicket != null) offTicket.cancel();
        setOutput(true);
      }
      else
        startOnTimer();
    }
    else if(!input && lastInput)
    {
      lastInput = input;
      if(getOffDelay().getMillis() == 0l)
      {
        if (onTicket != null) onTicket.cancel();
        setOutput(false);
      }
      else
      startOffTimer();
    }
    //else
    //{
    //  lastInput = input;
    //  setOutput(input);
    //}
  }

  private void setOutput(boolean value)
  {
    getOut().setValue(value);
    getOutNot().setValue(!value);
  }

  public void doOnTimerExpired()
  {
    setOutput(true);
    setOnDelayActive(false);
  }

  public void doOffTimerExpired()
  {
    setOutput(false);
    setOffDelayActive(false);
  }

  void startOnTimer()
  {
    if( offTicket != null) offTicket.cancel();
    if (onTicket != null) onTicket.cancel();
    onTicket = Clock.schedule(this, getOnDelay(), onTimerExpired, null);
    setOnDelayActive(true);
    setOffDelayActive(false);
  }    
  
  void startOffTimer()
  {            
    if (onTicket != null) onTicket.cancel();
    if (offTicket != null) offTicket.cancel();
    offTicket = Clock.schedule(this, getOffDelay(), offTimerExpired, null);
    setOffDelayActive(true);
    setOnDelayActive(false);
  }    
  

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  public boolean getBoolean() { return getOut().getValue(); }

  public final BFacets getBooleanFacets() { return getFacets(); }

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }



  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  boolean lastInput = false;
  Clock.Ticket onTicket;      // Used to manage the current timer
  Clock.Ticket offTicket;      // Used to manage the current timer
  
}
