/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BUnaryMath is the superclass of all Baja math objects take
 * operate on a single input value. 
 *
 * If the input has null status, the output will be Double.NaN
 * and null status.  If the input is invalid but not null, the 
 * output will Double.NaN and have the same status as the input.
 *
 * @author    Dan Giorgis
 * @creation  8 Nov 00
 * @version   $Revision: 27$ $Date: 3/30/2004 3:42:52 PM$
 * @since     Baja 1.0
 */
public abstract class BUnaryMath
  extends BMath
{ 
  /*-
  
  class BUnaryMath
  {
    properties
    {
      inA: BStatusNumeric
        -- Input A
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BUnaryMath(1932138644)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * Input A
   * @see com.tridium.kitControl.math.BUnaryMath#getInA
   * @see com.tridium.kitControl.math.BUnaryMath#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.math.BUnaryMath#inA
   */
  public BStatusNumeric getInA() { return (BStatusNumeric)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.math.BUnaryMath#inA
   */
  public void setInA(BStatusNumeric v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUnaryMath.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusNumeric inA = getInA();
    BStatus sa = inA.getStatus();                     
    BStatusNumeric out = (BStatusNumeric)o;

    //  Update output
    if (sa.isNull())
    {
      out.setValue(Double.NaN);
      out.setStatus(BStatus.nullStatus);
    }    
    else
    {
      out.setValue(calculate(inA.getValue()));   
      out.setStatus(propagate(sa));
    }
  }  

  abstract protected double calculate(double a);
}
