/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;

/**
 * BSquareRoot performs the operation out = sqrt(inA)
 * (square root of inA)
 *
 * @author    Dan Giorgis
 * @creation  29 Aug 2001
 * @version   $Revision: 7$ $Date: 3/30/2004 3:42:39 PM$
 * @since     Baja 1.0
 */
public class BSquareRoot
  extends BUnaryMath
{ 
  /*-  
  class BSquareRoot
  {
  }  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BSquareRoot(1875770456)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSquareRoot.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  protected double calculate(double a)
  {
    return Math.sqrt(a);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/math/squareRoot.png");

}