/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BMultiply performs the calculation out = inA * inB * inC * inD.
 *   
 * @author    Dan Giorgis
 * @creation  30 Aug 2001
 * @version   $Revision: 8$ $Date: 3/30/2004 3:42:16 PM$
 * @since     Niagara 3.0
 */
public class BMultiply
  extends BQuadMath
{  

  /*-
   class BMultiply
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BMultiply(3279695564)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMultiply.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  protected double calculate(BStatusNumeric a, BStatusNumeric b, BStatusNumeric c, BStatusNumeric d)
  {
    double result = 1;        
      
    //  Use only valid values
    if (a.getStatus().isValid()) result *= a.getValue(); 
    if (b.getStatus().isValid()) result *= b.getValue();
    if (c.getStatus().isValid()) result *= c.getValue();
    if (d.getStatus().isValid()) result *= d.getValue();

    return result;
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 1 for an BMultiply object.
   */
  public int minInputs() { return 1; }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/math/multiply.png");

}
