/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BMath is the abstract superclass of all Baja math 
 * objects.  These objects take 1-4 numeric inputs, 
 * perform a mathematical operation such as addition, 
 * averaging, sin, etc. and update the out property.
 * <p>
 * By convention, input values with invalid status 
 * (down, fault or null) bit set are ignored (not 
 * used in the math calculation).  However, the 
 * status bits set on the output are the logical 
 * OR of the status bits set on the input, with
 * one exception. If the null bit is set, any
 * other bits (status, in_alarm, etc) are ignored.
 * <p>
 * By  default, all 'in' property slots have the null 
 * bit set, therefore unlinked values are ignored. 
 * If all inputs have the null bit set, the output
 * will have the null bit set.  
 * <p>
 * Each math object requires a minimum number of 
 * inputs. If less than the minimum number of inputs 
 * are non-null, the output will have the null bit set.
 * <p>
 * Input values with the Double.NaN are NOT ignored.
 * The calculation will proceed normally, resulting
 * in a Double.NaN output.
 *
 * @author    Dan Giorgis
 * @creation  8 Nov 00
 * @version   $Revision: 17$ $Date: 3/30/2004 3:42:02 PM$
 * @since     Baja 1.0
 */
public abstract class BMath
  extends BNumericPoint
{ 
  /*-
  
  class BMath
  {
    properties
    {
      propagateFlags: BStatus
      -- defines which input status flags will be propagated from
      -- input to output.
        default{[ BStatus.ok ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BMath(170722530)1.0$ @*/
/* Generated Tue Aug 03 10:16:21 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see com.tridium.kitControl.math.BMath#getPropagateFlags
   * @see com.tridium.kitControl.math.BMath#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.ok,null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.math.BMath#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.math.BMath#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMath.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  private static final BFacets PROPAGATE_FACETS = 
    BFacets.make(BFacets.FIELD_EDITOR, BString.make("kitControl:PropagateFlagsFE"), BFacets.UX_FIELD_EDITOR, BString.make("kitControl:PropagateFlagsEditor"));

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("propagateFlags"))
    {
      return PROPAGATE_FACETS;
    }
    else return super.getSlotFacets(slot);
  }

  /**
   * Create a new status by masking out only the standard
   * flags which should be propagated from inputs to outputs.
   * See PROPOGATE_MASK for the flags which are propagated.
   *
   * @return <code>make(s.getBits() & PROPOGATE_MASK)</code>
   */
  public BStatus propagate(BStatus s)
  {
    return BStatus.make(s.getBits() & getPropagateFlags().getBits());
  }

}