/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import java.math.BigInteger;

import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.*;

/**
 * BFactorial performs the factorial operation, out = inA!
 *
 * @author    Lee Adcock
 * @creation  18 June 2009
 * @version   $Revision: 6$ $Date: 3/30/2004 3:41:44 PM$
 * @since     Baja 1.0
 */
public class BFactorial
  extends BUnaryMath
{ 
  /*-  
  class BFactorial
  {
  }  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BFactorial(1080440832)1.0$ @*/
/* Generated Thu Jun 18 10:39:15 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFactorial.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  protected double calculate(double a)
  {
    double n = 1.0;

    for (int i=1; i<= a; i++)
    {
      n = n*i;
      if(Double.isInfinite(n))
      {
        return Double.POSITIVE_INFINITY;
      }
    }
    return n;
  }


  public void onExecute(BStatusValue o, Context cx)
  {
    super.onExecute(o, cx);

    BStatusNumeric out = (BStatusNumeric)o;
    if(out.getValue() == Double.POSITIVE_INFINITY)
    {
      out.setStatus(BStatus.makeFault(out.getStatus(), true));
    }
  }


  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/math/factorial.png");
  
}