/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BAverage determines the average value of valid inputs and
 * writes that value to out.  out = (inA + inB + inC + inD) / 4
 *   
 * @author    Dan Giorgis
 * @creation  30 Aug 2001
 * @version   $Revision: 10$ $Date: 3/30/2004 3:41:30 PM$
 * @since     Niagara 3.0
 */
public class BAverage
  extends BQuadMath
{  

  /*-
   class BAverage
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BAverage(514365111)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAverage.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
    

  protected double calculate(BStatusNumeric a, BStatusNumeric b, BStatusNumeric c, BStatusNumeric d)
  {
    double total = 0;        
    int numValid = 0;
  
    //  Use only valid values
    if (a.getStatus().isValid()) { total += a.getValue(); numValid++; }
    if (b.getStatus().isValid()) { total += b.getValue(); numValid++; }
    if (c.getStatus().isValid()) { total += c.getValue(); numValid++; }
    if (d.getStatus().isValid()) { total += d.getValue(); numValid++; }

    return total / numValid;
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 1 for an BMinimum object.
   */
  public int minInputs() { return 1; }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/math/average.png");

}
