/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BOr performs a logical OR on all valid inputs and writes
 * the result to the out property.
 *
 * @author    Dan Giorgis
 * @creation  29 Aug 2001
 * @version   $Revision: 7$ $Date: 3/12/2003 11:45:03 AM$
 * @since     Baja 1.0
 */
public class BOr
  extends BQuadLogic
{ 

  /*-
   class BOr
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BOr(181642442)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOr.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/





  protected boolean calculate(BStatusBoolean a, BStatusBoolean b, BStatusBoolean c, BStatusBoolean d)
  {
    boolean result = false;        
  
    //  Use only valid values.  If any input is valid and true, 
    //  return true.  If all inputs are invalid, return false
    if (a.getStatus().isValid()) { if (a.getValue()) return true; }
    if (b.getStatus().isValid()) { if (b.getValue()) return true; }
    if (c.getStatus().isValid()) { if (c.getValue()) return true; }
    if (d.getStatus().isValid()) { if (d.getValue()) return true; }

    return false;
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 1 for an BOr object.
   */
  public int minInputs() { return 1; }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/logic/or.png");

}
