/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BAnd performs a logical NOT on all inputs and writes
 * the result to the out property.
 *
 * @author    Bill Smith
 * @creation  5 Feb 2004
 * @version   $Revision: 2$ $Date: 2/6/2004 8:19:30 AM$
 * @since     Baja 1.0
 */
public class BNot
  extends BLogic
{ 

  /*-
   class BNot
  {
    properties
    {
      in: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BNot(3420895379)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.logic.BNot#getIn
   * @see com.tridium.kitControl.logic.BNot#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.logic.BNot#in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.logic.BNot#in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNot.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusBoolean in = getIn();
    BStatus aStatus = in.getStatus();

    int a = 0;
    BStatusBoolean out = (BStatusBoolean)o;
    
    if (!aStatus.isNull()){
      a = aStatus.getBits();
      out.setValue(calculate(in));   
      out.setStatus(propagate(BStatus.make(a)));        

      if (getNullOnInactive() && !(out.getValue()))
        out.setStatusNull(true);
    }
    else{
      out.setValue(false);
      out.setStatus(BStatus.nullStatus);
    }
  }

  protected boolean calculate(BStatusBoolean a)
  {
    if (a.getStatus().isValid())
      return !a.getValue();
    else
      return false;
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/logic/not.png");

}
