/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;


/**
 * BComparison is an abstract superclass for mathematical 
 * operations such as A > B, A >= B, etc.
 *
 * @author    Dan Giorgis
 * @creation  3 Nov 00
 * @version   $Revision: 29$ $Date: 3/30/2004 3:40:36 PM$
 * @since     Baja 1.0
 */
public abstract class BComparison
  extends BLogic
{ 

  /*-
  
  class BComparison
  {
    properties
    {
      inA: BStatusNumeric
        -- Input A
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      inB: BStatusNumeric
        -- Input B
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BComparison(3542597520)1.0$ @*/
/* Generated Wed Sep 29 10:26:47 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * Input A
   * @see com.tridium.kitControl.logic.BComparison#getInA
   * @see com.tridium.kitControl.logic.BComparison#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.logic.BComparison#inA
   */
  public BStatusNumeric getInA() { return (BStatusNumeric)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.logic.BComparison#inA
   */
  public void setInA(BStatusNumeric v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * Input B
   * @see com.tridium.kitControl.logic.BComparison#getInB
   * @see com.tridium.kitControl.logic.BComparison#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.logic.BComparison#inB
   */
  public BStatusNumeric getInB() { return (BStatusNumeric)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.logic.BComparison#inB
   */
  public void setInB(BStatusNumeric v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BComparison.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusNumeric inA = getInA();
    BStatusNumeric inB = getInB();
    BStatusBoolean out = (BStatusBoolean)o;

    BStatus sa = inA.getStatus();
    BStatus sb = inB.getStatus();

    //  If either input is null, force the output
    //  to null
    if (sa.isNull() || sb.isNull())
    { 
      out.setValue(false);
      out.setStatus(BStatus.nullStatus);            
    }
    else
    {
      out.setStatus(propagate(BStatus.make(sa.getBits() | sb.getBits())));
  
      //  If either input is invalid, force the output
      //  to false
      if (!sa.isValid() || !sb.isValid())        
        out.setValue(false);
      else
        out.setValue(calculate(inA.getValue(), inB.getValue()));         
      if(getNullOnInactive() && !(out.getValue()) )
        out.setStatusNull(true);
    }    
  }

  abstract protected boolean calculate(double valueA, 
                                       double valueB);

}
