/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.enums;

import javax.baja.sys.*;

/**
 * BOutsideAirOptimizationMode is an BEnum that defines operation modes of
 * the BOutsideAirOptimization object.
 *
 * @author    Andy Saunders
 * @creation  21 April 04
 * @version   $Revision: 11$ $Date: 03-Jun-04 1:11:35 PM$
 * @since     Baja 1.0
 */
public final class BOutsideAirOptimizationMode
  extends BFrozenEnum
{

  /*-
  enum BOutsideAirOptimizationMode
  {
    range
    {
      disabled,                      
      inputError,                   
      lowTemperature,               
      freeCooling,      
      noFreeCooling,         
    }
  }
    
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.enums.BOutsideAirOptimizationMode(1359459089)1.0$ @*/
/* Generated Tue Jul 03 12:48:08 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for disabled. */
  public static final int DISABLED = 0;
  /** Ordinal value for inputError. */
  public static final int INPUT_ERROR = 1;
  /** Ordinal value for lowTemperature. */
  public static final int LOW_TEMPERATURE = 2;
  /** Ordinal value for freeCooling. */
  public static final int FREE_COOLING = 3;
  /** Ordinal value for noFreeCooling. */
  public static final int NO_FREE_COOLING = 4;
  
  /** BOutsideAirOptimizationMode constant for disabled. */
  public static final BOutsideAirOptimizationMode disabled = new BOutsideAirOptimizationMode(DISABLED);
  /** BOutsideAirOptimizationMode constant for inputError. */
  public static final BOutsideAirOptimizationMode inputError = new BOutsideAirOptimizationMode(INPUT_ERROR);
  /** BOutsideAirOptimizationMode constant for lowTemperature. */
  public static final BOutsideAirOptimizationMode lowTemperature = new BOutsideAirOptimizationMode(LOW_TEMPERATURE);
  /** BOutsideAirOptimizationMode constant for freeCooling. */
  public static final BOutsideAirOptimizationMode freeCooling = new BOutsideAirOptimizationMode(FREE_COOLING);
  /** BOutsideAirOptimizationMode constant for noFreeCooling. */
  public static final BOutsideAirOptimizationMode noFreeCooling = new BOutsideAirOptimizationMode(NO_FREE_COOLING);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOutsideAirOptimizationMode.class);
  
  /** Factory method with ordinal. */
  public static BOutsideAirOptimizationMode make(int ordinal)
  {
    return (BOutsideAirOptimizationMode)disabled.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BOutsideAirOptimizationMode make(String tag)
  {
    return (BOutsideAirOptimizationMode)disabled.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BOutsideAirOptimizationMode(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BOutsideAirOptimizationMode DEFAULT = BOutsideAirOptimizationMode.disabled;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


      
}

