/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import java.io.*;
import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.*;
import com.tridium.kitControl.hvac.*;

 /*
 * Setpoint Load Shed Object
 *
 *   This object will provide the application developer
 *   with an easy method of implementing load shedding strategies. In response to an input
 *   link, which activates the SLS object, it will cause a specified setpoint to be raised
 *   or lowered by a specific amount
 *
 * @author    Andy Saunders
 * @creation  24 Mar 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */

public class BSetpointLoadShed
  extends BComponent
{
  /*-

  class BSetpointLoadShed
  {
    properties
    {
      temperatureFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1) ]}

      //
      // Inputs
      //
      enabled: BStatusBoolean
      -- 'true' input causes setpoint to be adjusted by offset
        flags { summary }
        default {[ new BStatusBoolean(true) ]}
      setpointIn: BStatusNumeric
      -- Setpoint input that will be adjusted by this object
        flags { summary }
        default {[ new BStatusNumeric() ]}

      htgOffset: BStatusNumeric
      --Setpoint will be adjusted by this signed (+ or -) amount if active and in heating mode
        flags { summary }
        default {[ new BStatusNumeric(6.0, BStatus.ok) ]}

      clgOffset: BStatusNumeric
      --Setpoint will be adjusted by this signed (+ or -) amount if active and in cooling mode
        flags { summary }
        default {[ new BStatusNumeric(3.0, BStatus.ok) ]}

      modeIn: BStatusEnum
      --0=Off, 1=Heating, 2=Cooling
        flags{ summary }
        default {[ new BStatusEnum( BDynamicEnum.make(0, BEnumRange.make( BOffHeatCool.TYPE )) ) ]}
        slotfacets {[ BFacets.makeEnum( BEnumRange.make( BOffHeatCool.TYPE ) ) ]}

      //
      // Outputs
      //
      offsetInEffect: BStatusBoolean
      --Output to indicate if setpointOut has been adjusted
        flags { summary, transient }
        default {[ new BStatusBoolean() ]}
      setpointOut: BStatusNumeric
      --Adjusted setpoint if active otherwise passes through original setpoint
        flags { summary }
        default {[ new BStatusNumeric() ]}

    }

    actions
    {
      calculate()
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BSetpointLoadShed(218155386)1.0$ @*/
/* Generated Thu Feb 14 09:31:33 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "temperatureFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getTemperatureFacets
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setTemperatureFacets
   */
  public static final Property temperatureFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1),null);
  
  /**
   * Get the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#temperatureFacets
   */
  public BFacets getTemperatureFacets() { return (BFacets)get(temperatureFacets); }
  
  /**
   * Set the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#temperatureFacets
   */
  public void setTemperatureFacets(BFacets v) { set(temperatureFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "enabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enabled</code> property.
   * 'true' input causes setpoint to be adjusted by offset
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getEnabled
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setEnabled
   */
  public static final Property enabled = newProperty(Flags.SUMMARY, new BStatusBoolean(true),null);
  
  /**
   * Get the <code>enabled</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#enabled
   */
  public BStatusBoolean getEnabled() { return (BStatusBoolean)get(enabled); }
  
  /**
   * Set the <code>enabled</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#enabled
   */
  public void setEnabled(BStatusBoolean v) { set(enabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpointIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpointIn</code> property.
   * Setpoint input that will be adjusted by this object
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getSetpointIn
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setSetpointIn
   */
  public static final Property setpointIn = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>setpointIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setpointIn
   */
  public BStatusNumeric getSetpointIn() { return (BStatusNumeric)get(setpointIn); }
  
  /**
   * Set the <code>setpointIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setpointIn
   */
  public void setSetpointIn(BStatusNumeric v) { set(setpointIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "htgOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>htgOffset</code> property.
   * Setpoint will be adjusted by this signed (+ or -) amount if active and in heating mode
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getHtgOffset
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setHtgOffset
   */
  public static final Property htgOffset = newProperty(Flags.SUMMARY, new BStatusNumeric(6.0, BStatus.ok),null);
  
  /**
   * Get the <code>htgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#htgOffset
   */
  public BStatusNumeric getHtgOffset() { return (BStatusNumeric)get(htgOffset); }
  
  /**
   * Set the <code>htgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#htgOffset
   */
  public void setHtgOffset(BStatusNumeric v) { set(htgOffset,v,null); }

////////////////////////////////////////////////////////////////
// Property "clgOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clgOffset</code> property.
   * Setpoint will be adjusted by this signed (+ or -) amount if active and in cooling mode
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getClgOffset
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setClgOffset
   */
  public static final Property clgOffset = newProperty(Flags.SUMMARY, new BStatusNumeric(3.0, BStatus.ok),null);
  
  /**
   * Get the <code>clgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#clgOffset
   */
  public BStatusNumeric getClgOffset() { return (BStatusNumeric)get(clgOffset); }
  
  /**
   * Set the <code>clgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#clgOffset
   */
  public void setClgOffset(BStatusNumeric v) { set(clgOffset,v,null); }

////////////////////////////////////////////////////////////////
// Property "modeIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>modeIn</code> property.
   * 0=Off, 1=Heating, 2=Cooling
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getModeIn
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setModeIn
   */
  public static final Property modeIn = newProperty(Flags.SUMMARY, new BStatusEnum( BDynamicEnum.make(0, BEnumRange.make( BOffHeatCool.TYPE )) ),BFacets.makeEnum( BEnumRange.make( BOffHeatCool.TYPE ) ));
  
  /**
   * Get the <code>modeIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#modeIn
   */
  public BStatusEnum getModeIn() { return (BStatusEnum)get(modeIn); }
  
  /**
   * Set the <code>modeIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#modeIn
   */
  public void setModeIn(BStatusEnum v) { set(modeIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "offsetInEffect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offsetInEffect</code> property.
   * Output to indicate if setpointOut has been adjusted
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getOffsetInEffect
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setOffsetInEffect
   */
  public static final Property offsetInEffect = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>offsetInEffect</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#offsetInEffect
   */
  public BStatusBoolean getOffsetInEffect() { return (BStatusBoolean)get(offsetInEffect); }
  
  /**
   * Set the <code>offsetInEffect</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#offsetInEffect
   */
  public void setOffsetInEffect(BStatusBoolean v) { set(offsetInEffect,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpointOut"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpointOut</code> property.
   * Adjusted setpoint if active otherwise passes through
   * original setpoint
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#getSetpointOut
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setSetpointOut
   */
  public static final Property setpointOut = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>setpointOut</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setpointOut
   */
  public BStatusNumeric getSetpointOut() { return (BStatusNumeric)get(setpointOut); }
  
  /**
   * Set the <code>setpointOut</code> property.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#setpointOut
   */
  public void setSetpointOut(BStatusNumeric v) { set(setpointOut,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#calculate()
   */
  public static final Action calculate = newAction(0,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BSetpointLoadShed#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSetpointLoadShed.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    super.started();
  }

  public void stopped()
    throws Exception
  {
    super.stopped();
  }

  public void changed(Property property, Context context)
  {
    super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
      return;
    if( property.equals(clgOffset) ||
        property.equals(htgOffset) ||
        property.equals(modeIn)    ||
        property.equals(setpointIn)||
        property.equals(enabled)       )
      doCalculate();

  }

  public BFacets getSlotFacets(Slot slot)
  {
    if(slot.equals(clgOffset)  ||
       slot.equals(htgOffset) ||
       slot.equals(setpointIn)  )
      return getTemperatureFacets();
    return super.getSlotFacets(slot);
  }

  public void atSteadyState()
  {
    doCalculate();
  }

  public void doCalculate()
  {
    double setpoint = getSetpointIn().getValue();
    int mode = getModeIn().getValue().getOrdinal();
    boolean shedActive = false;

    if ( getEnabled().getValue() && (mode != BOffHeatCool.OFF) )
    {
      if ( mode == BOffHeatCool.COOL )      //Cooling Mode
        setpoint = setpoint + getClgOffset().getValue();
      else    //Heating Mode
        setpoint = setpoint - getHtgOffset().getValue();
      shedActive = true;
    }
    getSetpointOut().setValue(setpoint);
    getOffsetInEffect().setValue(shedActive);

  }

////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////

}
