/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import java.io.*;
import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.*;
import com.tridium.kitControl.hvac.*;

 /*
 * Outside Air Optimization
 *
 *   This object uses the two sets of temperature and humidity inputs
 *   to find the air supply with the least amount of heat.  The freeCooling
 *   output will be set to false if outside &gt;= inside
 *   and set to true if outside &lt;= inside - (abs)thresholdSpan.
 *   The user can select temperature or enthalpy comparisons.
 *   There is also a low temperature check to protect against freezing.
 * 
 * @author    Andy Saunders
 * @creation  24 Mar 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BOutsideAirOptimization
  extends BComponent
{ 
  /*-
  
  class BOutsideAirOptimization
  {
    properties
    {
      temperatureFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1) ]}
      
      humidityFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("percent relative humidity"), 1) ]}
      //
      // Inputs
      //
      outsideTemp: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
      outsideHumidity: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
      insideTemp: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
      insideHumidity: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
      lowTemperatureLimit: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
      
      //
      // Outputs
      //
      outsideEnthalpy: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
      outsideEnthalpyString: BStatusString
        flags { summary, transient }
        default {[ new BStatusString("") ]}
      insideEnthalpy: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
      insideEnthalpyString: BStatusString
        flags { summary, transient }
        default {[ new BStatusString("") ]}
      freeCooling: BStatusBoolean
        flags { summary, transient }
        default {[ new BStatusBoolean() ]}
      currentMode: BStatusEnum
        flags { summary, transient, readonly }
        default {[ new BStatusEnum(BOutsideAirOptimizationMode.noFreeCooling) ]}
      
      //
      // Properties
      //
      thresholdSpan: float
        default {[ 1.0f ]}
      useEnthalpy: boolean
        default {[ true ]}
      freeCoolingCommand: boolean
        default {[ true ]}
      useNullOutput: boolean
        default {[ true ]}
      
    }
    
    actions
    {
      calculate()
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BOutsideAirOptimization(3611702575)1.0$ @*/
/* Generated Fri Jun 03 08:47:42 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "temperatureFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getTemperatureFacets
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setTemperatureFacets
   */
  public static final Property temperatureFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1),null);
  
  /**
   * Get the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#temperatureFacets
   */
  public BFacets getTemperatureFacets() { return (BFacets)get(temperatureFacets); }
  
  /**
   * Set the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#temperatureFacets
   */
  public void setTemperatureFacets(BFacets v) { set(temperatureFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "humidityFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getHumidityFacets
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setHumidityFacets
   */
  public static final Property humidityFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("percent relative humidity"), 1),null);
  
  /**
   * Get the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#humidityFacets
   */
  public BFacets getHumidityFacets() { return (BFacets)get(humidityFacets); }
  
  /**
   * Set the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#humidityFacets
   */
  public void setHumidityFacets(BFacets v) { set(humidityFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideTemp</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getOutsideTemp
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setOutsideTemp
   */
  public static final Property outsideTemp = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outsideTemp</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideTemp
   */
  public BStatusNumeric getOutsideTemp() { return (BStatusNumeric)get(outsideTemp); }
  
  /**
   * Set the <code>outsideTemp</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideTemp
   */
  public void setOutsideTemp(BStatusNumeric v) { set(outsideTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideHumidity"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getOutsideHumidity
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setOutsideHumidity
   */
  public static final Property outsideHumidity = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outsideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideHumidity
   */
  public BStatusNumeric getOutsideHumidity() { return (BStatusNumeric)get(outsideHumidity); }
  
  /**
   * Set the <code>outsideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideHumidity
   */
  public void setOutsideHumidity(BStatusNumeric v) { set(outsideHumidity,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideTemp</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getInsideTemp
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setInsideTemp
   */
  public static final Property insideTemp = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>insideTemp</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideTemp
   */
  public BStatusNumeric getInsideTemp() { return (BStatusNumeric)get(insideTemp); }
  
  /**
   * Set the <code>insideTemp</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideTemp
   */
  public void setInsideTemp(BStatusNumeric v) { set(insideTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideHumidity"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getInsideHumidity
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setInsideHumidity
   */
  public static final Property insideHumidity = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>insideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideHumidity
   */
  public BStatusNumeric getInsideHumidity() { return (BStatusNumeric)get(insideHumidity); }
  
  /**
   * Set the <code>insideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideHumidity
   */
  public void setInsideHumidity(BStatusNumeric v) { set(insideHumidity,v,null); }

////////////////////////////////////////////////////////////////
// Property "lowTemperatureLimit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lowTemperatureLimit</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getLowTemperatureLimit
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setLowTemperatureLimit
   */
  public static final Property lowTemperatureLimit = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>lowTemperatureLimit</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#lowTemperatureLimit
   */
  public BStatusNumeric getLowTemperatureLimit() { return (BStatusNumeric)get(lowTemperatureLimit); }
  
  /**
   * Set the <code>lowTemperatureLimit</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#lowTemperatureLimit
   */
  public void setLowTemperatureLimit(BStatusNumeric v) { set(lowTemperatureLimit,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getOutsideEnthalpy
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setOutsideEnthalpy
   */
  public static final Property outsideEnthalpy = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outsideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideEnthalpy
   */
  public BStatusNumeric getOutsideEnthalpy() { return (BStatusNumeric)get(outsideEnthalpy); }
  
  /**
   * Set the <code>outsideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideEnthalpy
   */
  public void setOutsideEnthalpy(BStatusNumeric v) { set(outsideEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideEnthalpyString"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideEnthalpyString</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getOutsideEnthalpyString
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setOutsideEnthalpyString
   */
  public static final Property outsideEnthalpyString = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusString(""),null);
  
  /**
   * Get the <code>outsideEnthalpyString</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideEnthalpyString
   */
  public BStatusString getOutsideEnthalpyString() { return (BStatusString)get(outsideEnthalpyString); }
  
  /**
   * Set the <code>outsideEnthalpyString</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#outsideEnthalpyString
   */
  public void setOutsideEnthalpyString(BStatusString v) { set(outsideEnthalpyString,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getInsideEnthalpy
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setInsideEnthalpy
   */
  public static final Property insideEnthalpy = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>insideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideEnthalpy
   */
  public BStatusNumeric getInsideEnthalpy() { return (BStatusNumeric)get(insideEnthalpy); }
  
  /**
   * Set the <code>insideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideEnthalpy
   */
  public void setInsideEnthalpy(BStatusNumeric v) { set(insideEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideEnthalpyString"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideEnthalpyString</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getInsideEnthalpyString
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setInsideEnthalpyString
   */
  public static final Property insideEnthalpyString = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusString(""),null);
  
  /**
   * Get the <code>insideEnthalpyString</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideEnthalpyString
   */
  public BStatusString getInsideEnthalpyString() { return (BStatusString)get(insideEnthalpyString); }
  
  /**
   * Set the <code>insideEnthalpyString</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#insideEnthalpyString
   */
  public void setInsideEnthalpyString(BStatusString v) { set(insideEnthalpyString,v,null); }

////////////////////////////////////////////////////////////////
// Property "freeCooling"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>freeCooling</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getFreeCooling
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setFreeCooling
   */
  public static final Property freeCooling = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>freeCooling</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#freeCooling
   */
  public BStatusBoolean getFreeCooling() { return (BStatusBoolean)get(freeCooling); }
  
  /**
   * Set the <code>freeCooling</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#freeCooling
   */
  public void setFreeCooling(BStatusBoolean v) { set(freeCooling,v,null); }

////////////////////////////////////////////////////////////////
// Property "currentMode"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>currentMode</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getCurrentMode
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setCurrentMode
   */
  public static final Property currentMode = newProperty(Flags.SUMMARY|Flags.TRANSIENT|Flags.READONLY, new BStatusEnum(BOutsideAirOptimizationMode.noFreeCooling),null);
  
  /**
   * Get the <code>currentMode</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#currentMode
   */
  public BStatusEnum getCurrentMode() { return (BStatusEnum)get(currentMode); }
  
  /**
   * Set the <code>currentMode</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#currentMode
   */
  public void setCurrentMode(BStatusEnum v) { set(currentMode,v,null); }

////////////////////////////////////////////////////////////////
// Property "thresholdSpan"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thresholdSpan</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getThresholdSpan
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setThresholdSpan
   */
  public static final Property thresholdSpan = newProperty(0, 1.0f,null);
  
  /**
   * Get the <code>thresholdSpan</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#thresholdSpan
   */
  public float getThresholdSpan() { return getFloat(thresholdSpan); }
  
  /**
   * Set the <code>thresholdSpan</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#thresholdSpan
   */
  public void setThresholdSpan(float v) { setFloat(thresholdSpan,v,null); }

////////////////////////////////////////////////////////////////
// Property "useEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>useEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getUseEnthalpy
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setUseEnthalpy
   */
  public static final Property useEnthalpy = newProperty(0, true,null);
  
  /**
   * Get the <code>useEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#useEnthalpy
   */
  public boolean getUseEnthalpy() { return getBoolean(useEnthalpy); }
  
  /**
   * Set the <code>useEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#useEnthalpy
   */
  public void setUseEnthalpy(boolean v) { setBoolean(useEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "freeCoolingCommand"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>freeCoolingCommand</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getFreeCoolingCommand
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setFreeCoolingCommand
   */
  public static final Property freeCoolingCommand = newProperty(0, true,null);
  
  /**
   * Get the <code>freeCoolingCommand</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#freeCoolingCommand
   */
  public boolean getFreeCoolingCommand() { return getBoolean(freeCoolingCommand); }
  
  /**
   * Set the <code>freeCoolingCommand</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#freeCoolingCommand
   */
  public void setFreeCoolingCommand(boolean v) { setBoolean(freeCoolingCommand,v,null); }

////////////////////////////////////////////////////////////////
// Property "useNullOutput"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>useNullOutput</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#getUseNullOutput
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#setUseNullOutput
   */
  public static final Property useNullOutput = newProperty(0, true,null);
  
  /**
   * Get the <code>useNullOutput</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#useNullOutput
   */
  public boolean getUseNullOutput() { return getBoolean(useNullOutput); }
  
  /**
   * Set the <code>useNullOutput</code> property.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#useNullOutput
   */
  public void setUseNullOutput(boolean v) { setBoolean(useNullOutput,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#calculate()
   */
  public static final Action calculate = newAction(0,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BOutsideAirOptimization#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOutsideAirOptimization.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    super.started();
  }

  public void stopped()
    throws Exception
  {
    super.stopped();
  }

  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
	    return;
    if( property.equals(outsideTemp)     ||
        property.equals(outsideHumidity) ||
        property.equals(insideTemp)      ||
        property.equals(insideHumidity)  ||
        property.equals(thresholdSpan)   ||
        property.equals(freeCoolingCommand) ||
        property.equals(useEnthalpy)           )
      doCalculate();

  }

  public BFacets getSlotFacets(Slot slot)
  {
    if(slot.equals(insideTemp)  ||
       slot.equals(outsideTemp) ||
       slot.equals(lowTemperatureLimit)  )
      return getTemperatureFacets();
    else if(slot.equals(insideHumidity) ||
            slot.equals(outsideHumidity)   )
      return getHumidityFacets();
    return super.getSlotFacets(slot);
  }

  public void atSteadyState()
  {
    doCalculate();
  }

  public void doCalculate()
  {
    if( !getOutsideTemp().getStatus().isValid()     || 
        !getOutsideHumidity().getStatus().isValid() || 
        !getInsideTemp().getStatus().isValid()      ||
        !getInsideHumidity().getStatus().isValid()     )
    {
      getCurrentMode().setValue( BOutsideAirOptimizationMode.inputError );
      return;
    }

    // all inputs are good
    if( getOutsideTemp().getValue() < getLowTemperatureLimit().getValue() )
    {
      setOutput(false);
      getCurrentMode().setValue(BOutsideAirOptimizationMode.lowTemperature) ;
      lowTemp = true;
      return;
    }

    // calculate enthalpies if necessary
    if( getUseEnthalpy() == true )
    {
      getOutsideEnthalpy().setValue( (double)Psychrometric.enthalpy((float)getOutsideTemp().getValue(), (float)getOutsideHumidity().getValue()) );
      getInsideEnthalpy().setValue( (double)Psychrometric.enthalpy((float)getInsideTemp().getValue(), (float)getInsideHumidity().getValue()) ) ;

      // format enthalpy strings
      if( getOutsideEnthalpy().getValue() > 0.0 )
        getOutsideEnthalpyString().setValue(  (int)getOutsideEnthalpy().getValue() + engUnits ) ;
      else
        getOutsideEnthalpyString().setValue( OUT_OF_RANGE );

      if( getInsideEnthalpy().getValue() > 0.0 )
        getInsideEnthalpyString().setValue( (int)getInsideEnthalpy().getValue() + engUnits ) ;
      else
        getInsideEnthalpyString().setValue( OUT_OF_RANGE );

      // compare enthalpies
      if( getOutsideEnthalpy().getValue() >= getInsideEnthalpy().getValue() )
      {
        setOutput(false);
        getCurrentMode().setValue( BOutsideAirOptimizationMode.noFreeCooling );
      }
      else if( getOutsideEnthalpy().getValue() <= (getInsideEnthalpy().getValue() - Math.abs((double)getThresholdSpan())) )
      {
        setOutput(true);
        getCurrentMode().setValue( BOutsideAirOptimizationMode.freeCooling );
      }
    }
    else	// compare temperature only
    {
      getOutsideEnthalpy().setValue(0.0);
      getInsideEnthalpy().setValue( 0.0);
      getOutsideEnthalpyString().setValue( UNUSED );
      getInsideEnthalpyString().setValue( UNUSED );
      // compare temperatures
      if( getOutsideTemp().getValue() >= getInsideTemp().getValue() )
      {
        setOutput(false);
        getCurrentMode().setValue( BOutsideAirOptimizationMode.noFreeCooling );
      }
      else if( getOutsideTemp().getValue() <= (getInsideTemp().getValue() - Math.abs((double)getThresholdSpan())) )
      {
        setOutput(true);
        getCurrentMode().setValue( BOutsideAirOptimizationMode.freeCooling );
      }
    }
  }

  private void setOutput(boolean value)
  {
    if(value)
      setFreeCooling( new BStatusBoolean(getFreeCoolingCommand(), BStatus.ok ) );
    else
    {
      if(getUseNullOutput())
        setFreeCooling(new BStatusBoolean(!getFreeCoolingCommand(), BStatus.nullStatus));
      else
        setFreeCooling(new BStatusBoolean(!getFreeCoolingCommand(), BStatus.ok));
    }
  }

  private BStatus getNoFreeCoolingStatus()
  {
    if(getUseNullOutput())
      return BStatus.nullStatus;
    return BStatus.ok;
  }

////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////

  static String engUnits = " BTU/lb"                         ;
  static String OUT_OF_RANGE =           "Input out of range";
  static String UNUSED =                 "Unused"            ;

  boolean lowTemp = false;



}
