/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.*;
import com.tridium.kitControl.hvac.*;

/** Night Purge Component
 *
 *   This component uses the two sets of temperature and humidity inputs
 *   to find the air supply with the least amount of heat when the
 *   purgeEnabled input is 'true'.  
 *   The freeCooling output will be set to false
 *     if outside >= inside 
 *   or set to  true 
 *     if outside <= inside - (abs)thresholdSpan 
 *     and insideTemp >= nightSetpoint.
 *
 *   For inside/outside comparisons, the user can select either temperature
 *   or enthalpy comparisons.
 *   There is also a low temperature check to protect against freezing.
 *
 * 
 * @author    Andy Saunders
 * @creation  20 April 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BNightPurge
  extends BComponent
{ 
  /*-
  
  class BNightPurge
  {
    properties
    {
      temperatureFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1) ]}
    
      humidityFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("percent relative humidity"), 1) ]}
        
      purgeEnabled:	BStatusBoolean
        flags{ summary }
        default {[ new BStatusBoolean() ]}
        
      outsideTemp: BStatusNumeric
        flags{ summary }
        default {[ new BStatusNumeric() ]}
        
      outsideHumidity: BStatusNumeric
        flags{ summary }
        default {[ new BStatusNumeric() ]}

      insideTemp: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      insideHumidity: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      lowTemperatureLimit: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
      
      nightSetpoint: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}

      //
      // Outputs
      //
      
      outsideEnthalpy: BStatusNumeric
        flags { summary, transient, readonly }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"), 2) ]}
        
      insideEnthalpy: BStatusNumeric
        flags { summary, transient, readonly }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"), 2) ]}
        
      freeCooling: BStatusBoolean
        flags { summary, transient, readonly }
        default {[ new BStatusBoolean() ]}
        
      currentMode: BStatusEnum
        flags { summary, transient, readonly }
        default {[ new BStatusEnum(BNightPurgeMode.disabled) ]}
    
      //
      // Properties
      //
      setpointDeadband: float
        default {[ 1.0f ]}
        
      thresholdSpan: float
        default {[ 1.0f ]}
        
      useEnthalpy: boolean
        default {[ true ]}
        
      freeCoolingCommand: boolean
        default {[ true ]}
        
      useNullOutput: boolean
        default {[ true ]}

    }
    
    actions
    {
      calculate()
        flags{ hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BNightPurge(3061771682)1.0$ @*/
/* Generated Thu Jun 02 15:34:58 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "temperatureFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getTemperatureFacets
   * @see com.tridium.kitControl.energy.BNightPurge#setTemperatureFacets
   */
  public static final Property temperatureFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1),null);
  
  /**
   * Get the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#temperatureFacets
   */
  public BFacets getTemperatureFacets() { return (BFacets)get(temperatureFacets); }
  
  /**
   * Set the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#temperatureFacets
   */
  public void setTemperatureFacets(BFacets v) { set(temperatureFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "humidityFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getHumidityFacets
   * @see com.tridium.kitControl.energy.BNightPurge#setHumidityFacets
   */
  public static final Property humidityFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("percent relative humidity"), 1),null);
  
  /**
   * Get the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#humidityFacets
   */
  public BFacets getHumidityFacets() { return (BFacets)get(humidityFacets); }
  
  /**
   * Set the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#humidityFacets
   */
  public void setHumidityFacets(BFacets v) { set(humidityFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "purgeEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>purgeEnabled</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getPurgeEnabled
   * @see com.tridium.kitControl.energy.BNightPurge#setPurgeEnabled
   */
  public static final Property purgeEnabled = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>purgeEnabled</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#purgeEnabled
   */
  public BStatusBoolean getPurgeEnabled() { return (BStatusBoolean)get(purgeEnabled); }
  
  /**
   * Set the <code>purgeEnabled</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#purgeEnabled
   */
  public void setPurgeEnabled(BStatusBoolean v) { set(purgeEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideTemp</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getOutsideTemp
   * @see com.tridium.kitControl.energy.BNightPurge#setOutsideTemp
   */
  public static final Property outsideTemp = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outsideTemp</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#outsideTemp
   */
  public BStatusNumeric getOutsideTemp() { return (BStatusNumeric)get(outsideTemp); }
  
  /**
   * Set the <code>outsideTemp</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#outsideTemp
   */
  public void setOutsideTemp(BStatusNumeric v) { set(outsideTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideHumidity"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getOutsideHumidity
   * @see com.tridium.kitControl.energy.BNightPurge#setOutsideHumidity
   */
  public static final Property outsideHumidity = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outsideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#outsideHumidity
   */
  public BStatusNumeric getOutsideHumidity() { return (BStatusNumeric)get(outsideHumidity); }
  
  /**
   * Set the <code>outsideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#outsideHumidity
   */
  public void setOutsideHumidity(BStatusNumeric v) { set(outsideHumidity,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideTemp</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getInsideTemp
   * @see com.tridium.kitControl.energy.BNightPurge#setInsideTemp
   */
  public static final Property insideTemp = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>insideTemp</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#insideTemp
   */
  public BStatusNumeric getInsideTemp() { return (BStatusNumeric)get(insideTemp); }
  
  /**
   * Set the <code>insideTemp</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#insideTemp
   */
  public void setInsideTemp(BStatusNumeric v) { set(insideTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideHumidity"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getInsideHumidity
   * @see com.tridium.kitControl.energy.BNightPurge#setInsideHumidity
   */
  public static final Property insideHumidity = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>insideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#insideHumidity
   */
  public BStatusNumeric getInsideHumidity() { return (BStatusNumeric)get(insideHumidity); }
  
  /**
   * Set the <code>insideHumidity</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#insideHumidity
   */
  public void setInsideHumidity(BStatusNumeric v) { set(insideHumidity,v,null); }

////////////////////////////////////////////////////////////////
// Property "lowTemperatureLimit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lowTemperatureLimit</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getLowTemperatureLimit
   * @see com.tridium.kitControl.energy.BNightPurge#setLowTemperatureLimit
   */
  public static final Property lowTemperatureLimit = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>lowTemperatureLimit</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#lowTemperatureLimit
   */
  public BStatusNumeric getLowTemperatureLimit() { return (BStatusNumeric)get(lowTemperatureLimit); }
  
  /**
   * Set the <code>lowTemperatureLimit</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#lowTemperatureLimit
   */
  public void setLowTemperatureLimit(BStatusNumeric v) { set(lowTemperatureLimit,v,null); }

////////////////////////////////////////////////////////////////
// Property "nightSetpoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nightSetpoint</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getNightSetpoint
   * @see com.tridium.kitControl.energy.BNightPurge#setNightSetpoint
   */
  public static final Property nightSetpoint = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>nightSetpoint</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#nightSetpoint
   */
  public BStatusNumeric getNightSetpoint() { return (BStatusNumeric)get(nightSetpoint); }
  
  /**
   * Set the <code>nightSetpoint</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#nightSetpoint
   */
  public void setNightSetpoint(BStatusNumeric v) { set(nightSetpoint,v,null); }

////////////////////////////////////////////////////////////////
// Property "outsideEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outsideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getOutsideEnthalpy
   * @see com.tridium.kitControl.energy.BNightPurge#setOutsideEnthalpy
   */
  public static final Property outsideEnthalpy = newProperty(Flags.SUMMARY|Flags.TRANSIENT|Flags.READONLY, new BStatusNumeric(),BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"), 2) );
  
  /**
   * Get the <code>outsideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#outsideEnthalpy
   */
  public BStatusNumeric getOutsideEnthalpy() { return (BStatusNumeric)get(outsideEnthalpy); }
  
  /**
   * Set the <code>outsideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#outsideEnthalpy
   */
  public void setOutsideEnthalpy(BStatusNumeric v) { set(outsideEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "insideEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>insideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getInsideEnthalpy
   * @see com.tridium.kitControl.energy.BNightPurge#setInsideEnthalpy
   */
  public static final Property insideEnthalpy = newProperty(Flags.SUMMARY|Flags.TRANSIENT|Flags.READONLY, new BStatusNumeric(),BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"), 2) );
  
  /**
   * Get the <code>insideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#insideEnthalpy
   */
  public BStatusNumeric getInsideEnthalpy() { return (BStatusNumeric)get(insideEnthalpy); }
  
  /**
   * Set the <code>insideEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#insideEnthalpy
   */
  public void setInsideEnthalpy(BStatusNumeric v) { set(insideEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "freeCooling"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>freeCooling</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getFreeCooling
   * @see com.tridium.kitControl.energy.BNightPurge#setFreeCooling
   */
  public static final Property freeCooling = newProperty(Flags.SUMMARY|Flags.TRANSIENT|Flags.READONLY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>freeCooling</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#freeCooling
   */
  public BStatusBoolean getFreeCooling() { return (BStatusBoolean)get(freeCooling); }
  
  /**
   * Set the <code>freeCooling</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#freeCooling
   */
  public void setFreeCooling(BStatusBoolean v) { set(freeCooling,v,null); }

////////////////////////////////////////////////////////////////
// Property "currentMode"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>currentMode</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getCurrentMode
   * @see com.tridium.kitControl.energy.BNightPurge#setCurrentMode
   */
  public static final Property currentMode = newProperty(Flags.SUMMARY|Flags.TRANSIENT|Flags.READONLY, new BStatusEnum(BNightPurgeMode.disabled),null);
  
  /**
   * Get the <code>currentMode</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#currentMode
   */
  public BStatusEnum getCurrentMode() { return (BStatusEnum)get(currentMode); }
  
  /**
   * Set the <code>currentMode</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#currentMode
   */
  public void setCurrentMode(BStatusEnum v) { set(currentMode,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpointDeadband"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpointDeadband</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getSetpointDeadband
   * @see com.tridium.kitControl.energy.BNightPurge#setSetpointDeadband
   */
  public static final Property setpointDeadband = newProperty(0, 1.0f,null);
  
  /**
   * Get the <code>setpointDeadband</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#setpointDeadband
   */
  public float getSetpointDeadband() { return getFloat(setpointDeadband); }
  
  /**
   * Set the <code>setpointDeadband</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#setpointDeadband
   */
  public void setSetpointDeadband(float v) { setFloat(setpointDeadband,v,null); }

////////////////////////////////////////////////////////////////
// Property "thresholdSpan"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thresholdSpan</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getThresholdSpan
   * @see com.tridium.kitControl.energy.BNightPurge#setThresholdSpan
   */
  public static final Property thresholdSpan = newProperty(0, 1.0f,null);
  
  /**
   * Get the <code>thresholdSpan</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#thresholdSpan
   */
  public float getThresholdSpan() { return getFloat(thresholdSpan); }
  
  /**
   * Set the <code>thresholdSpan</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#thresholdSpan
   */
  public void setThresholdSpan(float v) { setFloat(thresholdSpan,v,null); }

////////////////////////////////////////////////////////////////
// Property "useEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>useEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getUseEnthalpy
   * @see com.tridium.kitControl.energy.BNightPurge#setUseEnthalpy
   */
  public static final Property useEnthalpy = newProperty(0, true,null);
  
  /**
   * Get the <code>useEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#useEnthalpy
   */
  public boolean getUseEnthalpy() { return getBoolean(useEnthalpy); }
  
  /**
   * Set the <code>useEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#useEnthalpy
   */
  public void setUseEnthalpy(boolean v) { setBoolean(useEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "freeCoolingCommand"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>freeCoolingCommand</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getFreeCoolingCommand
   * @see com.tridium.kitControl.energy.BNightPurge#setFreeCoolingCommand
   */
  public static final Property freeCoolingCommand = newProperty(0, true,null);
  
  /**
   * Get the <code>freeCoolingCommand</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#freeCoolingCommand
   */
  public boolean getFreeCoolingCommand() { return getBoolean(freeCoolingCommand); }
  
  /**
   * Set the <code>freeCoolingCommand</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#freeCoolingCommand
   */
  public void setFreeCoolingCommand(boolean v) { setBoolean(freeCoolingCommand,v,null); }

////////////////////////////////////////////////////////////////
// Property "useNullOutput"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>useNullOutput</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#getUseNullOutput
   * @see com.tridium.kitControl.energy.BNightPurge#setUseNullOutput
   */
  public static final Property useNullOutput = newProperty(0, true,null);
  
  /**
   * Get the <code>useNullOutput</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#useNullOutput
   */
  public boolean getUseNullOutput() { return getBoolean(useNullOutput); }
  
  /**
   * Set the <code>useNullOutput</code> property.
   * @see com.tridium.kitControl.energy.BNightPurge#useNullOutput
   */
  public void setUseNullOutput(boolean v) { setBoolean(useNullOutput,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BNightPurge#calculate()
   */
  public static final Action calculate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BNightPurge#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNightPurge.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);

    super.started();
	  if( !Sys.atSteadyState() )
		  return;


  }

  public void stopped()
    throws Exception
  {
    if(ticket != null)
      ticket.cancel();
    super.stopped();
  }


  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
	    return;
    if( property.equals(purgeEnabled)    ||
        property.equals(nightSetpoint)   ||
        property.equals(lowTemperatureLimit)   ||
        property.equals(outsideTemp)     ||
        property.equals(outsideHumidity) ||
        property.equals(insideTemp)      ||
        property.equals(insideHumidity)  ||
        property.equals(thresholdSpan)   ||
        property.equals(freeCoolingCommand) ||
        property.equals(useEnthalpy)           )
      doCalculate();

  }

  public BFacets getSlotFacets(Slot slot)
  {
    if(slot.equals(insideTemp)  ||
       slot.equals(outsideTemp) ||
       slot.equals(nightSetpoint) ||
       slot.equals(setpointDeadband) ||
       slot.equals(lowTemperatureLimit)  )
      return getTemperatureFacets();
    else if(slot.equals(insideHumidity) ||
            slot.equals(outsideHumidity)   )
      return getHumidityFacets();
    return super.getSlotFacets(slot);
  }

  public void atSteadyState()
  {
    doCalculate();
  }

  public void doCalculate()
  {
    double purgeTempLimit = getNightSetpoint().getValue();
    if( !getPurgeEnabled().getValue() )
    {
      setOutput(false);
      mode = DISABLED;
    }
    else if( !getOutsideTemp().getStatus().isValid()     || 
        !getOutsideHumidity().getStatus().isValid() || 
        !getInsideTemp().getStatus().isValid()      ||
        !getInsideHumidity().getStatus().isValid()     )
    {
      mode = INPUT_ERROR;
    }
    else
    {
      // all inputs are good
      // no need to do anything if outside temp is < lowTemperature limit
      if( getOutsideTemp().getValue() < getLowTemperatureLimit().getValue() )
      {
        mode = LOW_TEMPERATURE;
      }
      else
      {
        if(mode == SATISFIED)
          purgeTempLimit = getNightSetpoint().getValue() + (double)getSetpointDeadband();
        // is night purge needed
        if( getInsideTemp().getValue() < purgeTempLimit)
        {
          mode = SATISFIED;
        }
        else
        {
          // calculate enthalpies if necessary
          if( getUseEnthalpy() == true )
          {
            getOutsideEnthalpy().setValue( (double)Psychrometric.enthalpy((float)getOutsideTemp().getValue(), (float)getOutsideHumidity().getValue()) );
            getInsideEnthalpy().setValue( (double)Psychrometric.enthalpy((float)getInsideTemp().getValue(), (float)getInsideHumidity().getValue()) ) ;

            // format enthalpy strings
            boolean outEntError =  getOutsideEnthalpy().getValue() <= 0.0;
            getOutsideEnthalpy().setStatus( BStatus.makeFault(BStatus.make(0), outEntError ) );


            boolean inEntError = getInsideEnthalpy().getValue() <= 0.0;
            getInsideEnthalpy().setStatus( BStatus.makeFault(BStatus.make(0), inEntError ) );

            if (outEntError || inEntError) 
            {
              mode = INPUT_ERROR;
            }
            else
            {
              // compare enthalpies
              if( getOutsideEnthalpy().getValue() >= getInsideEnthalpy().getValue() )
              {
                mode = ENTHALPY_NO_FREE_COOLING;
              }
              else if( getOutsideEnthalpy().getValue() <= ( getInsideEnthalpy().getValue() - Math.abs((double)getThresholdSpan()) ) )
              {
                mode = ENTHALPY_FREE_COOLING;
              }
            }
          }
          else	// compare temperature only
          {
            getOutsideEnthalpy().setValue(0.0);
            getInsideEnthalpy().setValue( 0.0);
            getOutsideEnthalpy().setStatus( BStatus.make(0, BFacets.make("unused", true) ) );
            getInsideEnthalpy().setStatus( BStatus.make(0, BFacets.make("unused", true) ) );
            // compare temperatures
            if( getOutsideTemp().getValue() >= getInsideTemp().getValue() )
            {
              mode = TEMP_NO_FREE_COOLING;
            }
            else if( getOutsideTemp().getValue() <= ( getInsideTemp().getValue() - Math.abs((double)getThresholdSpan()) ) )
            {
              mode = TEMP_FREE_COOLING;
            }
          }
        }
      }
    }
    switch (mode) 
    {
    case DISABLED                :setOutput(false); getCurrentMode().setValue(BNightPurgeMode.disabled); break;
    case INPUT_ERROR             :setOutput(false); getCurrentMode().setValue(BNightPurgeMode.inputError); break;
    case LOW_TEMPERATURE         :setOutput(false); getCurrentMode().setValue(BNightPurgeMode.lowTemperature); break;
    case ENTHALPY_NO_FREE_COOLING:
    case TEMP_NO_FREE_COOLING    :setOutput(false); getCurrentMode().setValue(BNightPurgeMode.noFreeCooling); break;
    case ENTHALPY_FREE_COOLING   :
    case TEMP_FREE_COOLING       :setOutput(true) ; getCurrentMode().setValue(BNightPurgeMode.freeCooling); break;
    case SATISFIED               :setOutput(false); getCurrentMode().setValue(BNightPurgeMode.satisfied); break;
    default:

    }
  }

  private void setOutput(boolean value)
  {
    if(value)
      setFreeCooling( new BStatusBoolean(getFreeCoolingCommand(), BStatus.ok ) );
    else
    {
      if(getUseNullOutput())
        setFreeCooling(new BStatusBoolean(!getFreeCoolingCommand(), BStatus.nullStatus));
      else
        setFreeCooling(new BStatusBoolean(!getFreeCoolingCommand(), BStatus.ok));
    }
  }

////////////////////////////////////////////////////////////////
// constants
////////////////////////////////////////////////////////////////
  private static final int DISABLED                 = 0;
  private static final int INPUT_ERROR              = 1;
  private static final int LOW_TEMPERATURE          = 2;
  private static final int ENTHALPY_NO_FREE_COOLING = 3;
  private static final int ENTHALPY_FREE_COOLING    = 4;
  private static final int TEMP_NO_FREE_COOLING     = 5;
  private static final int TEMP_FREE_COOLING        = 6;
  private static final int SATISFIED                = 7;



////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////
  
  int mode = 0;
  Clock.Ticket ticket = null;

}