/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.BNullValueOverrideSelect;

/**
 * BStatusNumericToDouble is a component that converts a float to a statusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public abstract class BStatusValueToValue
  extends BComponent
{
  /*-
  
  class BStatusValueToValue
  {
    properties
    {
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusValueToValue(120302421)1.0$ @*/
/* Generated Fri Jul 16 08:28:14 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusValueToValue.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusValueToValue()
  {
  }
  
/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if(p.getName().equals(ON_NULL_IN_VALUE_NAME))
    {
      if(getOnNullInValue().getOrdinal() == BNullValueOverrideSelect.SPECIFY_OUT_VALUE)
      {
        BValue nVal = get(NULL_VALUE_PROPERTY_NAME);
        if(nVal == null)
        {
          add(NULL_VALUE_PROPERTY_NAME, (BValue)getOutType().getInstance());
        }
      }
      else
      {
        try{remove(NULL_VALUE_PROPERTY_NAME);}
        catch(Exception e){}
      }
      execute();
    }
    else if(p.getName().equals(NULL_VALUE_PROPERTY_NAME))
      execute();
      
  }

  public abstract Type getOutType();
  
  public abstract BFacets getOutFacets();
//  {
//    throw(new RuntimeException("BStatusValueToValue.getOutFacets(): SubClass should override"));
//  }
  
  public abstract void execute();
//  {
//    throw(new RuntimeException("BStatusValueToValue.getOutType(): SubClass should override"));
//  }

  public abstract BNullValueOverrideSelect getOnNullInValue(); 
//  { 
//    throw(new RuntimeException("BStatusValueToValue.getOnNullInValue(): SubClass should override"));
//  }

  public void setOnNullInValue(BNullValueOverrideSelect value)
  {
    throw(new RuntimeException("BStatusValueToValue.setOnNullInValue(): SubClass should override"));
  }

  public BValue calculate(BStatusValue sValue)
  {
    if( sValue.getStatus().isNull() && 
        getOnNullInValue().getOrdinal() == BNullValueOverrideSelect.SPECIFY_OUT_VALUE )
    {
      return get(NULL_VALUE_PROPERTY_NAME);
    }
    else
    {
      return sValue.getValueValue() ;
    }
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if(slot.getName().equals(NULL_VALUE_PROPERTY_NAME))
      return getOutFacets();
    return super.getSlotFacets(slot);
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");
  public static String NULL_VALUE_PROPERTY_NAME = "outValueOnNull";
  public static final String ON_NULL_IN_VALUE_NAME = "onNullInValue";

  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  
}
